/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cbor;

import com.authlete.cbor.CBORBigInteger;
import com.authlete.cbor.CBORBoolean;
import com.authlete.cbor.CBORBreak;
import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORConstants;
import com.authlete.cbor.CBORDecoderException;
import com.authlete.cbor.CBORDecoderOptions;
import com.authlete.cbor.CBORDefaultDecoderOptions;
import com.authlete.cbor.CBORDouble;
import com.authlete.cbor.CBORFloat;
import com.authlete.cbor.CBORInsufficientDataException;
import com.authlete.cbor.CBORInteger;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORItemList;
import com.authlete.cbor.CBORLong;
import com.authlete.cbor.CBORNull;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORPairList;
import com.authlete.cbor.CBORSimpleValue;
import com.authlete.cbor.CBORString;
import com.authlete.cbor.CBORTooLongException;
import com.authlete.cbor.CBORUndefined;
import com.authlete.cbor.tag.CBORTagProcessor;
import com.authlete.cbor.tag.CPDefault;
import com.authlete.cbor.token.CBORToken;
import com.authlete.cbor.token.CBORTokenizer;
import com.authlete.cbor.token.CTArrayOpener;
import com.authlete.cbor.token.CTBigInteger;
import com.authlete.cbor.token.CTBreak;
import com.authlete.cbor.token.CTByteString;
import com.authlete.cbor.token.CTDoubleFloatingPoint;
import com.authlete.cbor.token.CTFalse;
import com.authlete.cbor.token.CTFloatingPoint;
import com.authlete.cbor.token.CTIndefiniteArrayOpener;
import com.authlete.cbor.token.CTIndefiniteByteStringOpener;
import com.authlete.cbor.token.CTIndefiniteMapOpener;
import com.authlete.cbor.token.CTIndefiniteTextStringOpener;
import com.authlete.cbor.token.CTInteger;
import com.authlete.cbor.token.CTMapOpener;
import com.authlete.cbor.token.CTNull;
import com.authlete.cbor.token.CTSimpleValue;
import com.authlete.cbor.token.CTTag;
import com.authlete.cbor.token.CTTextString;
import com.authlete.cbor.token.CTTrue;
import com.authlete.cbor.token.CTUndefined;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class CBORDecoder {
    private final CBORTokenizer tokenizer;
    private final CBORDecoderOptions options;

    public CBORDecoder(byte[] input) {
        this(input, null);
    }

    public CBORDecoder(byte[] input, CBORDecoderOptions options) {
        this(new ByteArrayInputStream(input), options);
    }

    public CBORDecoder(byte[] input, int offset, int length) {
        this(input, offset, length, null);
    }

    public CBORDecoder(byte[] input, int offset, int length, CBORDecoderOptions options) {
        this(new ByteArrayInputStream(input, offset, length), options);
    }

    public CBORDecoder(InputStream inputStream) {
        this(inputStream, null);
    }

    public CBORDecoder(InputStream inputStream, CBORDecoderOptions options) {
        this.tokenizer = new CBORTokenizer(inputStream);
        this.options = options != null ? options : new CBORDefaultDecoderOptions();
    }

    public CBORDecoderOptions getOptions() {
        return this.options;
    }

    public CBORItem next() throws IOException {
        return this.nextItem();
    }

    public List<CBORItem> all() throws IOException {
        CBORItem item;
        ArrayList<CBORItem> list = new ArrayList<CBORItem>();
        while ((item = this.next()) != null) {
            list.add(item);
        }
        return list;
    }

    private CBORToken<?> nextToken() throws IOException {
        return this.tokenizer.next();
    }

    private CBORItem nextItem() throws IOException {
        CBORToken<?> token = this.nextToken();
        if (token == null) {
            return null;
        }
        if (token instanceof CTInteger) {
            return this.buildFromInteger((CTInteger)token);
        }
        if (token instanceof CTBigInteger) {
            return new CBORBigInteger((BigInteger)token.getValue());
        }
        if (token instanceof CTByteString) {
            return new CBORByteArray((byte[])token.getValue());
        }
        if (token instanceof CTIndefiniteByteStringOpener) {
            return this.nextIndefiniteByteStringSequence();
        }
        if (token instanceof CTTextString) {
            return new CBORString((String)token.getValue());
        }
        if (token instanceof CTIndefiniteTextStringOpener) {
            return this.nextIndefiniteTextStringSequence();
        }
        if (token instanceof CTArrayOpener) {
            return this.nextArray(((CTArrayOpener)token).getSize());
        }
        if (token instanceof CTIndefiniteArrayOpener) {
            return this.nextIndefiniteArray();
        }
        if (token instanceof CTMapOpener) {
            return this.nextMap(((CTMapOpener)token).getSize());
        }
        if (token instanceof CTIndefiniteMapOpener) {
            return this.nextIndefiniteMap();
        }
        if (token instanceof CTTag) {
            return this.nextTag((CTTag)token);
        }
        if (token instanceof CTSimpleValue) {
            return new CBORSimpleValue((Integer)token.getValue());
        }
        if (token instanceof CTFalse) {
            return CBORBoolean.FALSE;
        }
        if (token instanceof CTTrue) {
            return CBORBoolean.TRUE;
        }
        if (token instanceof CTNull) {
            return CBORNull.INSTANCE;
        }
        if (token instanceof CTUndefined) {
            return CBORUndefined.INSTANCE;
        }
        if (token instanceof CTFloatingPoint) {
            return this.buildFromFloatingPoint((CTFloatingPoint)token);
        }
        if (token instanceof CTBreak) {
            return CBORBreak.INSTANCE;
        }
        throw new AssertionError((Object)String.format("Unknown token '%s' in nextItem()", token.getClass().getSimpleName()));
    }

    private CBORItem buildFromInteger(CTInteger token) {
        Long value = (Long)token.getValue();
        if (CBORConstants.LONG_INT_MIN.compareTo(value) <= 0 && value.compareTo(CBORConstants.LONG_INT_MAX) <= 0) {
            return new CBORInteger(value.intValue());
        }
        return new CBORLong(value);
    }

    private CBORItem buildFromFloatingPoint(CTFloatingPoint<?> token) {
        if (token instanceof CTDoubleFloatingPoint) {
            return new CBORDouble((Double)token.getValue());
        }
        return new CBORFloat((Float)token.getValue());
    }

    private CBORByteArray nextIndefiniteByteStringSequence() throws IOException {
        CBORToken<?> token;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        while ((token = this.nextToken()) instanceof CTByteString) {
            baos.write((byte[])token.getValue());
        }
        if (!(token instanceof CTBreak)) {
            throw this.invalidToken("an indefinite-length byte string sequence", token);
        }
        return new CBORByteArray(baos.toByteArray());
    }

    private CBORString nextIndefiniteTextStringSequence() throws IOException {
        CBORToken<?> token;
        StringBuilder sb = new StringBuilder();
        while ((token = this.nextToken()) instanceof CTTextString) {
            sb.append((String)token.getValue());
        }
        if (!(token instanceof CTBreak)) {
            throw this.invalidToken("an indefinite-length text string sequence", token);
        }
        return new CBORString(sb.toString());
    }

    private CBORItemList nextArray(Number size) throws IOException {
        int len = this.checkSize("array", size);
        ArrayList<CBORItem> list = new ArrayList<CBORItem>();
        for (int i = 0; i < len; ++i) {
            CBORItem item = this.nextItem();
            if (item == null) {
                throw this.insufficientData("an array");
            }
            if (item instanceof CBORBreak) {
                throw this.unexpectedBreak("an array");
            }
            list.add(item);
        }
        return new CBORItemList((List<? extends CBORItem>)list);
    }

    private CBORItemList nextIndefiniteArray() throws IOException {
        ArrayList<CBORItem> list = new ArrayList<CBORItem>();
        while (true) {
            CBORItem item;
            if ((item = this.nextItem()) == null) {
                throw this.insufficientData("an indefinite-length array");
            }
            if (item instanceof CBORBreak) break;
            list.add(item);
        }
        return new CBORItemList((List<? extends CBORItem>)list);
    }

    private CBORPairList nextMap(Number size) throws IOException {
        int len = this.checkSize("map", size);
        ArrayList<CBORPair> list = new ArrayList<CBORPair>();
        for (int i = 0; i < len; ++i) {
            CBORItem key = this.nextItem();
            if (key == null) {
                throw this.insufficientData("a map key");
            }
            if (key instanceof CBORBreak) {
                throw this.unexpectedBreak("a map key");
            }
            CBORItem value = this.nextItem();
            if (value == null) {
                throw this.insufficientData("a map value");
            }
            if (value instanceof CBORBreak) {
                throw this.unexpectedBreak("a map value");
            }
            list.add(new CBORPair(key, value));
        }
        return new CBORPairList((List<? extends CBORPair>)list);
    }

    private CBORPairList nextIndefiniteMap() throws IOException {
        ArrayList<CBORPair> list = new ArrayList<CBORPair>();
        while (true) {
            CBORItem key;
            if ((key = this.nextItem()) == null) {
                throw this.insufficientData("a key of an indefinite-length map");
            }
            if (key instanceof CBORBreak) break;
            CBORItem value = this.nextItem();
            if (value == null) {
                throw this.insufficientData("a value of an indefinite-length map");
            }
            if (value instanceof CBORBreak) {
                throw this.unexpectedBreak("a value of an indefinite-length map");
            }
            list.add(new CBORPair(key, value));
        }
        return new CBORPairList((List<? extends CBORPair>)list);
    }

    private CBORItem nextTag(CTTag tag) throws IOException {
        CBORItem item = this.nextItem();
        if (item == null) {
            throw this.insufficientData("a tag content");
        }
        Number tagNumber = (Number)tag.getValue();
        CBORTagProcessor processor = this.getTagProcessor(tagNumber);
        if (processor == null) {
            processor = CPDefault.INSTANCE;
        }
        return processor.process(tagNumber, item);
    }

    private CBORTagProcessor getTagProcessor(Number tagNumber) {
        return this.options.getTagProcessor(tagNumber);
    }

    private CBORDecoderException invalidToken(String target, CBORToken<?> token) {
        if (token == null) {
            return this.insufficientData(target);
        }
        return this.unexpectedToken(target, token);
    }

    private CBORDecoderException insufficientData(String target) {
        return new CBORInsufficientDataException(String.format("The end of the input stream was reached during reading %s.", target), this.tokenizer.getReadCount());
    }

    private CBORDecoderException unexpectedToken(String target, CBORToken<?> token) {
        return new CBORDecoderException(String.format("An unexpected CBOR token appeared during reading %s: token=%s, major=%d, info=%d", target, token.getClass().getSimpleName(), token.getMajor(), token.getInfo()), this.tokenizer.getReadCount());
    }

    private CBORDecoderException unexpectedBreak(String target) {
        return new CBORDecoderException(String.format("An unexpected break appeared during reading %s.", target), this.tokenizer.getReadCount());
    }

    private CBORDecoderException tooBig(String target, Number size) {
        return new CBORTooLongException(String.format("The size of the CBOR %s is impractically big: size=%s", target, size.toString()), this.tokenizer.getReadCount());
    }

    private int checkSize(String target, Number size) throws CBORDecoderException {
        if (size instanceof BigInteger) {
            throw this.tooBig(target, size);
        }
        Long length = (Long)size;
        if (CBORConstants.LONG_INT_MAX.compareTo(length) < 0) {
            throw this.tooBig(target, size);
        }
        return length.intValue();
    }
}

