/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cbor;

import com.authlete.cbor.CBORConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Base64;

public abstract class CBORItem {
    private String mComment;

    public String getComment() {
        return this.mComment;
    }

    public void setComment(String comment) {
        this.mComment = comment;
    }

    public abstract Object parse();

    public abstract void encode(OutputStream var1) throws IOException;

    public final byte[] encode() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.encode(baos);
        }
        catch (IOException cause) {
            return null;
        }
        return baos.toByteArray();
    }

    public String encodeToBase64() {
        return Base64.getEncoder().encodeToString(this.encode());
    }

    public String encodeToBase64Url() {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(this.encode());
    }

    public String encodeToHex() {
        StringBuilder sb = new StringBuilder();
        for (byte b : this.encode()) {
            sb.append(CBORItem.toHex(b));
        }
        return sb.toString();
    }

    private static String toHex(int b) {
        return String.format("%02x", 0xFF & b);
    }

    protected String toString(Number tagNumber) {
        return this.toString();
    }

    public String prettify() {
        return this.prettify("", "  ", null);
    }

    protected String prettify(String indent, String indentUnit, Number tagNumber) {
        String comment = this.getComment();
        String content = this.toString();
        if (comment != null) {
            return String.format("/ %s / %s", comment, content);
        }
        return content;
    }

    protected void encodeMajorWithNumber(OutputStream outputStream, int major, Number number) throws IOException {
        int shiftedMajor = major << 5;
        if (number instanceof Integer) {
            this.encodeMajorWithInteger(outputStream, shiftedMajor, number.intValue());
        } else if (number instanceof Long) {
            this.encodeMajorWithLong(outputStream, shiftedMajor, number.longValue());
        } else if (number instanceof BigInteger) {
            this.encodeMajorWithBigInteger(outputStream, shiftedMajor, (BigInteger)number);
        } else {
            throw new AssertionError((Object)String.format("The number given to encodeMajorWithNumber() is unexpected: %s", number == null ? "null" : number.getClass().getSimpleName()));
        }
    }

    private void encodeMajorWithInteger(OutputStream outputStream, int shiftedMajor, int value) throws IOException {
        if (value < 24) {
            outputStream.write(shiftedMajor | value);
        } else if (value <= 255) {
            this.encodeMajorWith8Bits(outputStream, shiftedMajor, value);
        } else if (value <= 65535) {
            this.encodeMajorWith16Bits(outputStream, shiftedMajor, value);
        } else {
            this.encodeMajorWith32Bits(outputStream, shiftedMajor, value);
        }
    }

    private void encodeMajorWithLong(OutputStream outputStream, int shiftedMajor, long value) throws IOException {
        if (value <= Integer.MAX_VALUE) {
            this.encodeMajorWithInteger(outputStream, shiftedMajor, (int)value);
        } else if (value <= -1L) {
            this.encodeMajorWith32Bits(outputStream, shiftedMajor, (int)value);
        } else {
            this.encodeMajorWith64Bits(outputStream, shiftedMajor, value);
        }
    }

    private void encodeMajorWithBigInteger(OutputStream outputStream, int shiftedMajor, BigInteger number) throws IOException {
        long value = number.longValue();
        if (number.compareTo(CBORConstants.BIG_INTEGER_LONG_MAX) <= 0) {
            this.encodeMajorWithLong(outputStream, shiftedMajor, value);
        } else {
            this.encodeMajorWith64Bits(outputStream, shiftedMajor, value);
        }
    }

    private void encodeMajorWith8Bits(OutputStream outputStream, int shiftedMajor, int value) throws IOException {
        outputStream.write(shiftedMajor | 0x18);
        outputStream.write(value);
    }

    private void encodeMajorWith16Bits(OutputStream outputStream, int shiftedMajor, int value) throws IOException {
        outputStream.write(shiftedMajor | 0x19);
        outputStream.write(value >> 8);
        outputStream.write(value);
    }

    private void encodeMajorWith32Bits(OutputStream outputStream, int shiftedMajor, int value) throws IOException {
        outputStream.write(shiftedMajor | 0x1A);
        outputStream.write(value >> 24);
        outputStream.write(value >> 16);
        outputStream.write(value >> 8);
        outputStream.write(value);
    }

    private void encodeMajorWith64Bits(OutputStream outputStream, int shiftedMajor, long value) throws IOException {
        outputStream.write(shiftedMajor | 0x1B);
        outputStream.write((int)(value >> 56));
        outputStream.write((int)(value >> 48));
        outputStream.write((int)(value >> 40));
        outputStream.write((int)(value >> 32));
        outputStream.write((int)(value >> 24));
        outputStream.write((int)(value >> 16));
        outputStream.write((int)(value >> 8));
        outputStream.write((int)value);
    }
}

