/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cbor;

import com.authlete.cbor.CBORItem;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CBORItemList
extends CBORItem {
    private final List<? extends CBORItem> items;

    public CBORItemList(List<? extends CBORItem> items) {
        this.items = items;
    }

    public <T extends CBORItem> CBORItemList(T ... items) {
        this(Arrays.asList(items));
    }

    public List<? extends CBORItem> getItems() {
        return this.items;
    }

    public String toString() {
        return this.buildString();
    }

    private String buildString() {
        if (this.items == null) {
            return "[]";
        }
        return this.items.stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
    }

    @Override
    protected String prettify(String indent, String indentUnit, Number tagNumber) {
        String comment;
        String string = comment = this.getComment() == null ? "" : String.format("/ %s / ", this.getComment());
        if (this.items == null || this.items.size() == 0) {
            return String.format("%s[%n%s]", comment, indent);
        }
        String delimiter = String.format(",%n", new Object[0]);
        String prefix = String.format("%s[%n", comment);
        String suffix = String.format("%n%s]", indent);
        String subIndent = indent + indentUnit;
        return this.items.stream().map(item -> String.format("%s%s", subIndent, item.prettify(subIndent, indentUnit, null))).collect(Collectors.joining(delimiter, prefix, suffix));
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        if (this.items == null) {
            this.encodeMajorWithNumber(outputStream, 4, 0);
            return;
        }
        this.encodeMajorWithNumber(outputStream, 4, this.items.size());
        for (CBORItem cBORItem : this.items) {
            cBORItem.encode(outputStream);
        }
    }

    @Override
    public List<Object> parse() {
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.items != null) {
            this.items.stream().map(CBORItem::parse).forEachOrdered(list::add);
        }
        return list;
    }
}

