/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cbor;

import com.authlete.cbor.CBORBoolean;
import com.authlete.cbor.CBORDouble;
import com.authlete.cbor.CBORFloat;
import com.authlete.cbor.CBORInteger;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORLong;
import com.authlete.cbor.CBORizer;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Map;

public class CBOROutputStream
extends FilterOutputStream {
    private final CBORizer cborizer = new CBORizer();

    public CBOROutputStream(OutputStream out) {
        super(out);
    }

    public CBORBoolean writeBoolean(boolean value) throws IOException {
        CBORBoolean item = this.cborizer.cborizeBoolean(value);
        item.encode(this);
        return item;
    }

    public CBORInteger writeInteger(int value) throws IOException {
        CBORInteger item = this.cborizer.cborizeInteger(value);
        item.encode(this);
        return item;
    }

    public CBORLong writeLong(long value) throws IOException {
        CBORLong item = this.cborizer.cborizeLong(value);
        item.encode(this);
        return item;
    }

    public CBORItem writeBigInteger(BigInteger value) throws IOException {
        CBORItem item = this.cborizer.cborizeBigInteger(value);
        item.encode(this);
        return item;
    }

    public CBORFloat writeFloat(float value) throws IOException {
        CBORFloat item = this.cborizer.cborizeFloat(value);
        item.encode(this);
        return item;
    }

    public CBORDouble writeDouble(double value) throws IOException {
        CBORDouble item = this.cborizer.cborizeDouble(value);
        item.encode(this);
        return item;
    }

    public CBORItem writeByteArray(byte[] value) throws IOException {
        CBORItem item = this.cborizer.cborizeByteArray(value);
        item.encode(this);
        return item;
    }

    public CBORItem writeString(String value) throws IOException {
        CBORItem item = this.cborizer.cborizeString(value);
        item.encode(this);
        return item;
    }

    public CBORItem writeCollection(Collection<?> collection) throws IOException {
        CBORItem item = this.cborizer.cborizeCollection(collection);
        item.encode(this);
        return item;
    }

    public CBORItem writeMap(Map<?, ?> map) throws IOException {
        CBORItem item = this.cborizer.cborizeMap(map);
        item.encode(this);
        return item;
    }

    public CBORItem writeObject(Object object) throws IOException {
        CBORItem item = this.cborizer.cborizeObject(object);
        item.encode(this);
        return item;
    }
}

