/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cbor;

import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORNull;
import java.io.IOException;
import java.io.OutputStream;

public class CBORPair {
    private final CBORItem key;
    private final CBORItem value;
    private String keyComment;
    private String valueComment;

    public CBORPair(CBORItem key, CBORItem value) {
        this(key, value, null, null);
    }

    public CBORPair(CBORItem key, CBORItem value, String keyComment, String valueComment) {
        this.key = key != null ? key : CBORNull.INSTANCE;
        this.value = value != null ? value : CBORNull.INSTANCE;
        this.keyComment = keyComment;
        this.valueComment = valueComment;
    }

    public CBORItem getKey() {
        return this.key;
    }

    public CBORItem getValue() {
        return this.value;
    }

    public String getKeyComment() {
        return this.keyComment;
    }

    public CBORPair setKeyComment(String comment) {
        this.keyComment = comment;
        return this;
    }

    public String getValueComment() {
        return this.valueComment;
    }

    public CBORPair setValueComment(String comment) {
        this.valueComment = comment;
        return this;
    }

    public String toString() {
        return this.buildString();
    }

    private String buildString() {
        return String.format("%s: %s", this.key, this.value);
    }

    public String prettify(String indent, String indentUnit) {
        String kComment = this.getKeyComment() == null ? "" : String.format("/ %s / ", this.getKeyComment());
        String vComment = this.getValueComment() == null ? "" : String.format(" / %s /", this.getValueComment());
        return String.format("%s%s: %s%s", kComment, this.key.prettify(indent, indentUnit, null), this.value.prettify(indent, indentUnit, null), vComment);
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.key.encode(outputStream);
        this.value.encode(outputStream);
    }
}

