/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cbor;

import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORValue;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CBORPairList
extends CBORItem {
    private final List<? extends CBORPair> pairs;

    public CBORPairList(List<? extends CBORPair> pairs) {
        this.pairs = pairs;
    }

    public <T extends CBORPair> CBORPairList(T ... pairs) {
        this(Arrays.asList(pairs));
    }

    public List<? extends CBORPair> getPairs() {
        return this.pairs;
    }

    public String toString() {
        return this.buildString();
    }

    private String buildString() {
        if (this.pairs == null) {
            return "{}";
        }
        return this.pairs.stream().map(CBORPair::toString).collect(Collectors.joining(", ", "{", "}"));
    }

    @Override
    protected String prettify(String indent, String indentUnit, Number tagNumber) {
        String comment;
        String string = comment = this.getComment() == null ? "" : String.format("/ %s / ", this.getComment());
        if (this.pairs == null || this.pairs.size() == 0) {
            return String.format("%s{%n%s}", comment, indent);
        }
        String delimiter = String.format(",%n", new Object[0]);
        String prefix = String.format("%s{%n", comment);
        String suffix = String.format("%n%s}", indent);
        String subIndent = indent + indentUnit;
        return this.pairs.stream().map(pair -> String.format("%s%s", subIndent, pair.prettify(subIndent, indentUnit))).collect(Collectors.joining(delimiter, prefix, suffix));
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        if (this.pairs == null) {
            this.encodeMajorWithNumber(outputStream, 5, 0);
            return;
        }
        this.encodeMajorWithNumber(outputStream, 5, this.pairs.size());
        for (CBORPair cBORPair : this.pairs) {
            cBORPair.encode(outputStream);
        }
    }

    @Override
    public Map<Object, Object> parse() {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        if (this.pairs != null) {
            for (CBORPair cBORPair : this.pairs) {
                Object key = cBORPair.getKey().parse();
                Object value = cBORPair.getValue().parse();
                map.put(key, value);
            }
        }
        return map;
    }

    public CBORPair findByKey(Object key) {
        if (key == null) {
            return null;
        }
        if (this.pairs == null) {
            return null;
        }
        for (CBORPair cBORPair : this.pairs) {
            if (!(cBORPair.getKey() instanceof CBORValue) || !key.equals(((CBORValue)cBORPair.getKey()).getValue())) continue;
            return cBORPair;
        }
        return null;
    }
}

