/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cbor;

import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORizer;
import java.util.ArrayList;
import java.util.List;

public class CBORPairsBuilder {
    private final List<CBORPair> mList = new ArrayList<CBORPair>();

    public CBORPairsBuilder add(CBORItem label, CBORItem value) {
        this.mList.add(new CBORPair(label, value));
        return this;
    }

    public CBORPairsBuilder add(CBORItem label, Object value) {
        return this.add(label, new CBORizer().cborize(value));
    }

    public CBORPairsBuilder add(Object label, Object value) {
        CBORizer cborizer = new CBORizer();
        return this.add(cborizer.cborize(label), cborizer.cborize(value));
    }

    public CBORPairsBuilder addUnlessNull(CBORItem label, CBORItem value) {
        if (value != null) {
            this.add(label, value);
        }
        return this;
    }

    public CBORPairsBuilder addUnlessNull(CBORItem label, Object value) {
        if (value != null) {
            this.add(label, value);
        }
        return this;
    }

    public CBORPairsBuilder addUnlessNull(Object label, Object value) {
        if (value != null) {
            CBORizer cborizer = new CBORizer();
            this.add(cborizer.cborize(label), cborizer.cborize(value));
        }
        return this;
    }

    public List<CBORPair> build() {
        return this.mList;
    }
}

