/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cbor;

import com.authlete.cbor.CBORDecoder;
import com.authlete.cbor.CBORItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class CBORParser {
    private final CBORDecoder decoder;

    public CBORParser(byte[] input) {
        this(new CBORDecoder(input));
    }

    public CBORParser(InputStream inputStream) {
        this(new CBORDecoder(inputStream));
    }

    public CBORParser(CBORDecoder decoder) {
        if (decoder == null) {
            throw new NullPointerException("The CBOR decoder given to the constructor is null.");
        }
        this.decoder = decoder;
    }

    public Object next() throws IOException {
        CBORItem item = this.decoder.next();
        if (item == null) {
            return null;
        }
        return item.parse();
    }

    public List<Object> all() throws IOException {
        Object item;
        ArrayList<Object> items = new ArrayList<Object>();
        while ((item = this.next()) != null) {
            items.add(item);
        }
        return items;
    }

    public CBORDecoder getDecoder() {
        return this.decoder;
    }
}

