/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cbor;

import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORNull;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class CBORTaggedItem
extends CBORItem {
    private final Number tagNumber;
    private final CBORItem tagContent;

    public CBORTaggedItem(Number tagNumber, CBORItem tagContent) {
        if (tagNumber == null) {
            throw new NullPointerException("The tag number given to the constructor is null.");
        }
        if (!(tagNumber instanceof Integer || tagNumber instanceof Long || tagNumber instanceof BigInteger)) {
            throw new IllegalArgumentException("The class of the tag number must be Integer, Long or BigInteger.");
        }
        this.tagNumber = tagNumber;
        this.tagContent = tagContent != null ? tagContent : CBORNull.INSTANCE;
    }

    public Number getTagNumber() {
        return this.tagNumber;
    }

    public CBORItem getTagContent() {
        return this.tagContent;
    }

    public String toString() {
        return this.buildString();
    }

    private String buildString() {
        return String.format("%s(%s)", this.tagNumber.toString(), this.tagContent.toString(this.tagNumber));
    }

    @Override
    protected String prettify(String indent, String indentUnit, Number upperTagNumber) {
        String comment = this.getComment() == null ? "" : String.format("/ %s / ", this.getComment());
        return String.format("%s%s(%s)", comment, this.tagNumber.toString(), this.tagContent.prettify(indent, indentUnit, this.tagNumber));
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        this.encodeMajorWithNumber(outputStream, 6, this.tagNumber);
        this.tagContent.encode(outputStream);
    }

    @Override
    public Object parse() {
        return this.tagContent.parse();
    }
}

