/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cbor;

import com.authlete.cbor.CBORString;
import com.authlete.cbor.CBORTaggedItem;
import com.authlete.cbor.CBORValue;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;

public class CBORUri
extends CBORValue<URI> {
    private final boolean tagged;
    private final Number tagNumber;

    public CBORUri(URI value) {
        this(value, false);
    }

    public CBORUri(URI value, boolean tagged) {
        this(value, tagged, 32);
    }

    public CBORUri(URI value, boolean tagged, Number tagNumber) {
        super(value);
        this.tagged = tagged;
        this.tagNumber = tagNumber;
    }

    @Override
    public void encode(OutputStream outputStream) throws IOException {
        CBORString text = new CBORString(((URI)this.getValue()).toString());
        if (this.tagged) {
            new CBORTaggedItem(this.tagNumber, text).encode(outputStream);
        } else {
            text.encode(outputStream);
        }
    }
}

