/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cbor;

import com.authlete.cbor.CBORBigInteger;
import com.authlete.cbor.CBORBoolean;
import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORDiagnosticNotationParser;
import com.authlete.cbor.CBORDouble;
import com.authlete.cbor.CBORFloat;
import com.authlete.cbor.CBORInteger;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORItemList;
import com.authlete.cbor.CBORLong;
import com.authlete.cbor.CBORNull;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORPairList;
import com.authlete.cbor.CBORString;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CBORizer {
    private static final String DEFAULT_DIAGNOSTIC_NOTATION_PREFIX = "cbor:";
    private String mDiagnosticNotationPrefix = "cbor:";
    private CBORDiagnosticNotationParser mDiagnosticNotationParser;

    public String getDiagnosticNotationPrefix() {
        return this.mDiagnosticNotationPrefix;
    }

    public CBORizer setDiagnosticNotationPrefix(String prefix) {
        this.mDiagnosticNotationPrefix = prefix;
        return this;
    }

    public CBORDiagnosticNotationParser getDiagnosticNotationParser() {
        return this.mDiagnosticNotationParser;
    }

    public CBORizer setDiagnosticNotationParser(CBORDiagnosticNotationParser parser) {
        this.mDiagnosticNotationParser = parser;
        return this;
    }

    public CBORBoolean cborizeBoolean(boolean value) {
        return value ? CBORBoolean.TRUE : CBORBoolean.FALSE;
    }

    public CBORInteger cborizeInteger(int value) {
        return new CBORInteger(value);
    }

    public CBORLong cborizeLong(long value) {
        return new CBORLong(value);
    }

    public CBORItem cborizeBigInteger(BigInteger value) {
        if (value == null) {
            return CBORNull.INSTANCE;
        }
        return new CBORBigInteger(value);
    }

    public CBORFloat cborizeFloat(float value) {
        return new CBORFloat(Float.valueOf(value));
    }

    public CBORDouble cborizeDouble(double value) {
        return new CBORDouble(value);
    }

    public CBORItem cborizeByteArray(byte[] value) {
        if (value == null) {
            return CBORNull.INSTANCE;
        }
        return new CBORByteArray(value);
    }

    public CBORItem cborizeString(String value) {
        if (value == null) {
            return CBORNull.INSTANCE;
        }
        CBORDiagnosticNotationParser parser = this.getDiagnosticNotationParser();
        if (parser == null) {
            return new CBORString(value);
        }
        String prefix = this.getDiagnosticNotationPrefix();
        if (prefix == null || prefix.isEmpty()) {
            return parser.parseItem(value);
        }
        if (value.startsWith(prefix)) {
            return parser.parseItem(value.substring(prefix.length()));
        }
        return new CBORString(value);
    }

    public CBORItem cborizeCollection(Collection<?> collection) {
        if (collection == null) {
            return CBORNull.INSTANCE;
        }
        ArrayList<CBORItem> list = new ArrayList<CBORItem>();
        for (Object element : collection) {
            list.add(this.cborize(element));
        }
        return new CBORItemList((List<? extends CBORItem>)list);
    }

    public CBORItem cborizeMap(Map<?, ?> map) {
        if (map == null) {
            return CBORNull.INSTANCE;
        }
        ArrayList<CBORPair> pairs = new ArrayList<CBORPair>();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            CBORItem key = this.cborize(entry.getKey());
            CBORItem value = this.cborize(entry.getValue());
            pairs.add(new CBORPair(key, value));
        }
        return new CBORPairList((List<? extends CBORPair>)pairs);
    }

    public CBORItem cborizeObject(Object object) {
        if (object == null) {
            return CBORNull.INSTANCE;
        }
        if (object instanceof Boolean) {
            return this.cborizeBoolean((Boolean)object);
        }
        if (object instanceof Byte) {
            return this.cborizeInteger(((Byte)object).intValue());
        }
        if (object instanceof Short) {
            return this.cborizeInteger(((Short)object).intValue());
        }
        if (object instanceof Integer) {
            return this.cborizeInteger((Integer)object);
        }
        if (object instanceof Long) {
            return this.cborizeLong((Long)object);
        }
        if (object instanceof BigInteger) {
            return this.cborizeBigInteger((BigInteger)object);
        }
        if (object instanceof Float) {
            return this.cborizeFloat(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return this.cborizeDouble((Double)object);
        }
        if (object instanceof byte[]) {
            return this.cborizeByteArray((byte[])object);
        }
        if (object instanceof String) {
            return this.cborizeString((String)object);
        }
        if (object instanceof Collection) {
            return this.cborizeCollection((Collection)object);
        }
        if (object instanceof Map) {
            return this.cborizeMap((Map)object);
        }
        if (object instanceof CBORItem) {
            return (CBORItem)object;
        }
        return this.cborizeString(object.toString());
    }

    public CBORItem cborize(Object object) {
        return this.cborizeObject(object);
    }
}

