/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cbor.tag;

import com.authlete.cbor.CBORBigInteger;
import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORConstants;
import com.authlete.cbor.CBORDecoderException;
import com.authlete.cbor.CBORInteger;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORLong;
import com.authlete.cbor.tag.CBORTagProcessor;
import java.math.BigInteger;

public class CPBignum
implements CBORTagProcessor {
    public static final CPBignum INSTANCE = new CPBignum();

    @Override
    public CBORItem process(Number tagNumber, CBORItem tagContent) throws CBORDecoderException {
        boolean unsigned;
        int tag = tagNumber.intValue();
        boolean bl = unsigned = tag == 2;
        if (!(tagContent instanceof CBORByteArray)) {
            throw new CBORDecoderException(String.format("The tag content for the tag number '%d' must be a byte string.", tag));
        }
        byte[] data = (byte[])((CBORByteArray)tagContent).getValue();
        if (CPBignum.allZero(data)) {
            return new CBORInteger(unsigned ? 0 : -1);
        }
        BigInteger value = new BigInteger(1, data);
        if (unsigned) {
            return CPBignum.buildUnsigned(value);
        }
        return CPBignum.buildNegative(value);
    }

    private static boolean allZero(byte[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == 0) continue;
            return false;
        }
        return true;
    }

    private static CBORItem buildUnsigned(BigInteger value) {
        if (value.compareTo(CBORConstants.BIG_INTEGER_INT_MAX) <= 0) {
            return new CBORInteger(value.intValue());
        }
        if (value.compareTo(CBORConstants.BIG_INTEGER_LONG_MAX) <= 0) {
            return new CBORLong(value.longValue());
        }
        return new CBORBigInteger(value);
    }

    private static CBORItem buildNegative(BigInteger value) {
        if (CBORConstants.BIG_INTEGER_INT_MIN.compareTo(value = CBORConstants.BIG_INTEGER_MINUS_ONE.subtract(value)) <= 0) {
            return new CBORInteger(value.intValue());
        }
        if (CBORConstants.BIG_INTEGER_LONG_MIN.compareTo(value) <= 0) {
            return new CBORLong(value.longValue());
        }
        return new CBORBigInteger(value);
    }
}

