/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cbor.tag;

import com.authlete.cbor.CBORDecoderException;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORString;
import com.authlete.cbor.CBORUri;
import com.authlete.cbor.tag.CBORTagProcessor;
import java.net.URI;

public class CPUri
implements CBORTagProcessor {
    private final boolean conversion;

    public CPUri() {
        this(true);
    }

    public CPUri(boolean conversion) {
        this.conversion = conversion;
    }

    @Override
    public CBORItem process(Number tagNumber, CBORItem tagContent) throws CBORDecoderException {
        URI uri;
        if (!(tagContent instanceof CBORString)) {
            throw new CBORDecoderException(String.format("The tag content for the tag number '%s' must be a text string.", tagNumber.toString()));
        }
        String text = (String)((CBORString)tagContent).getValue();
        try {
            uri = new URI(text);
        }
        catch (Exception cause) {
            throw new CBORDecoderException(String.format("The text string tagged by the tag number '%s' is not a valid URI: %s", tagNumber.toString(), text));
        }
        if (this.conversion) {
            return new CBORUri(uri);
        }
        return tagContent;
    }
}

