/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cbor.token;

import com.authlete.cbor.CBORConstants;
import com.authlete.cbor.CBORInsufficientDataException;
import com.authlete.cbor.CBORInvalidInfoException;
import com.authlete.cbor.CBORInvalidSimpleValueException;
import com.authlete.cbor.CBORMalformedUtf8Exception;
import com.authlete.cbor.CBORTooLongException;
import com.authlete.cbor.token.CBORToken;
import com.authlete.cbor.token.CTArrayOpener;
import com.authlete.cbor.token.CTBreak;
import com.authlete.cbor.token.CTByteString;
import com.authlete.cbor.token.CTDoubleFloatingPoint;
import com.authlete.cbor.token.CTFalse;
import com.authlete.cbor.token.CTHalfFloatingPoint;
import com.authlete.cbor.token.CTIndefiniteArrayOpener;
import com.authlete.cbor.token.CTIndefiniteByteStringOpener;
import com.authlete.cbor.token.CTIndefiniteMapOpener;
import com.authlete.cbor.token.CTIndefiniteTextStringOpener;
import com.authlete.cbor.token.CTMapOpener;
import com.authlete.cbor.token.CTNegativeBigInteger;
import com.authlete.cbor.token.CTNegativeInteger;
import com.authlete.cbor.token.CTNull;
import com.authlete.cbor.token.CTNumber;
import com.authlete.cbor.token.CTSimpleValue;
import com.authlete.cbor.token.CTSingleFloatingPoint;
import com.authlete.cbor.token.CTTag;
import com.authlete.cbor.token.CTTextString;
import com.authlete.cbor.token.CTTrue;
import com.authlete.cbor.token.CTUndefined;
import com.authlete.cbor.token.CTUnsignedBigInteger;
import com.authlete.cbor.token.CTUnsignedInteger;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;

public class CBORTokenizer {
    private final InputStream inputStream;
    private int readCount;

    public CBORTokenizer(InputStream inputStream) {
        if (inputStream == null) {
            throw new NullPointerException("The input stream given to the constructor is null.");
        }
        this.inputStream = inputStream;
    }

    public int getReadCount() {
        return this.readCount;
    }

    public CBORToken<?> next() throws IOException {
        int firstByte = this.read();
        if (firstByte < 0) {
            return null;
        }
        int major = (0xE0 & firstByte) >> 5;
        int info = 0x1F & firstByte;
        switch (major) {
            case 0: {
                return this.nextUnsignedInteger(major, info);
            }
            case 1: {
                return this.nextNegativeInteger(major, info);
            }
            case 2: {
                return this.nextByteString(major, info);
            }
            case 3: {
                return this.nextTextString(major, info);
            }
            case 4: {
                return this.nextArray(major, info);
            }
            case 5: {
                return this.nextMap(major, info);
            }
            case 6: {
                return this.nextTag(major, info);
            }
            case 7: {
                return this.nextMajor7(major, info);
            }
        }
        return null;
    }

    private int read() throws IOException {
        int value = this.inputStream.read();
        if (0 <= value) {
            ++this.readCount;
        }
        return value;
    }

    private byte[] readBytes(int major, int info, int length) throws IOException {
        byte[] buf;
        try {
            buf = new byte[length];
        }
        catch (OutOfMemoryError cause) {
            throw new CBORTooLongException(major, info, this.readCount, length);
        }
        int off = 0;
        int len = length;
        while (0 < len) {
            int count = this.inputStream.read(buf, off, len);
            if (count < 0) {
                return null;
            }
            off += count;
            len -= count;
            this.readCount += count;
        }
        return buf;
    }

    private Number readNumber(int major, int info) throws IOException {
        if (info == 31 && 2 <= major && major <= 5) {
            return null;
        }
        if (28 <= info) {
            throw new CBORInvalidInfoException(major, info, this.readCount - 1);
        }
        if (info < 24) {
            return (long)info;
        }
        int length = CBORTokenizer.pow(2, info - 24);
        byte[] buffer = this.readBytes(major, info, length);
        if (buffer == null) {
            throw new CBORInsufficientDataException(major, info, this.readCount, length);
        }
        return CBORTokenizer.parseNumber(buffer);
    }

    private static Number parseNumber(byte[] buffer) {
        switch (buffer.length) {
            case 1: {
                return (long)buffer[0] & 0xFFL;
            }
            case 2: {
                return ((long)buffer[0] & 0xFFL) << 8 | (long)buffer[1] & 0xFFL;
            }
            case 4: {
                return ((long)buffer[0] & 0xFFL) << 24 | ((long)buffer[1] & 0xFFL) << 16 | ((long)buffer[2] & 0xFFL) << 8 | (long)buffer[3] & 0xFFL;
            }
            case 8: {
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Unexpected length '%d' in parseNumber()", buffer.length));
            }
        }
        if (CBORTokenizer.allZero(buffer)) {
            return 0L;
        }
        BigInteger value = new BigInteger(1, buffer);
        if (value.compareTo(CBORConstants.BIG_INTEGER_LONG_MAX) <= 0) {
            return value.longValue();
        }
        return value;
    }

    private static float parseHalf(byte[] buffer) {
        boolean positive = (buffer[0] & 0x80) == 0;
        int exponent = (buffer[0] & 0x7C) >> 2;
        int fraction = (buffer[0] & 3) << 8 | buffer[1] & 0xFF;
        if (exponent == 0) {
            if (fraction == 0) {
                return positive ? 0.0f : -0.0f;
            }
        } else if (exponent == 31) {
            if (fraction == 0) {
                return positive ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
            }
            return Float.NaN;
        }
        int bits = 0;
        if (!positive) {
            bits |= Integer.MIN_VALUE;
        }
        if (exponent == 0) {
            while ((0x200 & fraction) == 0) {
                fraction <<= 1;
                --exponent;
            }
            fraction <<= 1;
            fraction &= 0x3FF;
        }
        bits |= exponent + 112 << 23;
        return Float.intBitsToFloat(bits |= fraction << 13);
    }

    private static float parseSingle(byte[] buffer) {
        return Float.intBitsToFloat((buffer[0] & 0xFF) << 24 | (buffer[1] & 0xFF) << 16 | (buffer[2] & 0xFF) << 8 | buffer[3] & 0xFF);
    }

    private static double parseDouble(byte[] buffer) {
        return Double.longBitsToDouble(((long)buffer[0] & 0xFFL) << 56 | ((long)buffer[1] & 0xFFL) << 48 | ((long)buffer[2] & 0xFFL) << 40 | ((long)buffer[3] & 0xFFL) << 32 | ((long)buffer[4] & 0xFFL) << 24 | ((long)buffer[5] & 0xFFL) << 16 | ((long)buffer[6] & 0xFFL) << 8 | (long)buffer[7] & 0xFFL);
    }

    private static int pow(int base, int exponent) {
        if (exponent == 0) {
            return 1;
        }
        int value = base;
        for (int i = 1; i < exponent; ++i) {
            value *= base;
        }
        return value;
    }

    private static boolean allZero(byte[] buffer) {
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] == 0) continue;
            return false;
        }
        return true;
    }

    private byte[] readLengthAndBytes(int major, int info) throws IOException {
        Number length = this.readNumber(major, info);
        if (length == null) {
            return null;
        }
        if (length instanceof BigInteger) {
            throw new CBORTooLongException(major, info, this.readCount, length);
        }
        if (Integer.MAX_VALUE < length.longValue()) {
            throw new CBORTooLongException(major, info, this.readCount, length);
        }
        int len = length.intValue();
        byte[] bytes = this.readBytes(major, info, len);
        if (bytes == null) {
            throw new CBORInsufficientDataException(major, info, this.readCount, len);
        }
        return bytes;
    }

    private String buildUtf8String(int major, int info, byte[] bytes) throws CBORMalformedUtf8Exception {
        try {
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
            return decoder.decode(byteBuffer).toString();
        }
        catch (Exception cause) {
            int offset = this.readCount - bytes.length;
            throw new CBORMalformedUtf8Exception(major, info, offset, cause);
        }
    }

    private CTNumber<?> nextUnsignedInteger(int major, int info) throws IOException {
        Number value = this.readNumber(major, info);
        if (value instanceof BigInteger) {
            return new CTUnsignedBigInteger(major, info, (BigInteger)value);
        }
        return new CTUnsignedInteger(major, info, (Long)value);
    }

    private CTNumber<?> nextNegativeInteger(int major, int info) throws IOException {
        Number rawValue = this.readNumber(major, info);
        if (rawValue instanceof BigInteger) {
            BigInteger value = CBORConstants.BIG_INTEGER_MINUS_ONE.subtract((BigInteger)rawValue);
            return new CTNegativeBigInteger(major, info, value);
        }
        long value = -1L - rawValue.longValue();
        return new CTNegativeInteger(major, info, value);
    }

    private CBORToken<?> nextByteString(int major, int info) throws IOException {
        byte[] bytes = this.readLengthAndBytes(major, info);
        if (bytes == null) {
            return CTIndefiniteByteStringOpener.INSTANCE;
        }
        return new CTByteString(major, info, bytes);
    }

    private CBORToken<?> nextTextString(int major, int info) throws IOException {
        byte[] bytes = this.readLengthAndBytes(major, info);
        if (bytes == null) {
            return CTIndefiniteTextStringOpener.INSTANCE;
        }
        String str = this.buildUtf8String(major, info, bytes);
        return new CTTextString(major, info, str);
    }

    private CBORToken<?> nextArray(int major, int info) throws IOException {
        Number size = this.readNumber(major, info);
        if (size == null) {
            return CTIndefiniteArrayOpener.INSTANCE;
        }
        return new CTArrayOpener(major, info, size);
    }

    private CBORToken<?> nextMap(int major, int info) throws IOException {
        Number size = this.readNumber(major, info);
        if (size == null) {
            return CTIndefiniteMapOpener.INSTANCE;
        }
        return new CTMapOpener(major, info, size);
    }

    private CBORToken<?> nextTag(int major, int info) throws IOException {
        Number number = this.readNumber(major, info);
        return new CTTag(major, info, number);
    }

    private CBORToken<?> nextMajor7(int major, int info) throws IOException {
        if (info <= 19) {
            return new CTSimpleValue(major, info, info);
        }
        switch (info) {
            case 20: {
                return CTFalse.INSTANCE;
            }
            case 21: {
                return CTTrue.INSTANCE;
            }
            case 22: {
                return CTNull.INSTANCE;
            }
            case 23: {
                return CTUndefined.INSTANCE;
            }
            case 24: {
                return this.nextSimpleValue(major, info);
            }
            case 25: 
            case 26: 
            case 27: {
                return this.nextFloatPoint(major, info);
            }
            case 28: 
            case 29: 
            case 30: {
                throw new CBORInvalidInfoException(major, info, this.readCount - 1);
            }
            case 31: {
                return CTBreak.INSTANCE;
            }
        }
        return null;
    }

    private CTSimpleValue nextSimpleValue(int major, int info) throws IOException {
        int value = this.read();
        if (value < 0) {
            throw new CBORInsufficientDataException(major, info, this.readCount, 1);
        }
        if (value < 32) {
            throw new CBORInvalidSimpleValueException(major, info, this.readCount - 1, value);
        }
        return new CTSimpleValue(major, info, value);
    }

    private CBORToken<?> nextFloatPoint(int major, int info) throws IOException {
        int length = CBORTokenizer.pow(2, info - 24);
        byte[] buffer = this.readBytes(major, info, length);
        if (buffer == null) {
            throw new CBORInsufficientDataException(major, info, this.readCount, length);
        }
        switch (length) {
            case 2: {
                return new CTHalfFloatingPoint(major, info, Float.valueOf(CBORTokenizer.parseHalf(buffer)));
            }
            case 4: {
                return new CTSingleFloatingPoint(major, info, Float.valueOf(CBORTokenizer.parseSingle(buffer)));
            }
            case 8: {
                return new CTDoubleFloatingPoint(major, info, CBORTokenizer.parseDouble(buffer));
            }
        }
        throw new AssertionError((Object)String.format("Unexpected length '%d' in nextFloatPoint()", buffer.length));
    }
}

