/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORBoolean;
import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORInteger;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORPairList;
import com.authlete.cbor.CBORPairsBuilder;
import com.authlete.cbor.CBORString;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEKey;
import com.authlete.cose.ECDSA;
import com.authlete.cose.constants.COSEEllipticCurves;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class COSEEC2Key
extends COSEKey {
    private Object crv;
    private byte[] x;
    private Object y;
    private byte[] d;

    public COSEEC2Key(List<? extends CBORPair> pairs) {
        super(pairs);
        this.validateParameters(pairs);
    }

    private void validateParameters(List<? extends CBORPair> pairs) {
        for (CBORPair cBORPair : pairs) {
            this.validateParameter(cBORPair);
        }
    }

    private void validateParameter(CBORPair pair) {
        CBORItem label = pair.getKey();
        if (!(label instanceof CBORInteger)) {
            return;
        }
        this.validateKnownParameter((Integer)((CBORInteger)label).getValue(), pair.getValue());
    }

    private void validateKnownParameter(int label, CBORItem value) {
        switch (label) {
            case -1: {
                this.crv = COSEEC2Key.validateCrv(value);
                break;
            }
            case -2: {
                this.x = COSEEC2Key.validateX(value);
                break;
            }
            case -3: {
                this.y = COSEEC2Key.validateY(value);
                break;
            }
            case -4: {
                this.d = COSEEC2Key.validateD(value);
                break;
            }
        }
    }

    private static Object validateCrv(CBORItem value) {
        if (COSEEC2Key.isInteger(value) || value instanceof CBORString) {
            return COSEEC2Key.getRawValue(value);
        }
        throw new IllegalArgumentException("crv (-1) must be an integer or a text string.");
    }

    private static byte[] validateX(CBORItem value) {
        if (value instanceof CBORByteArray) {
            return (byte[])COSEEC2Key.getRawValue(value);
        }
        throw new IllegalArgumentException("x (-2) must be a byte string.");
    }

    private static Object validateY(CBORItem value) {
        if (value instanceof CBORByteArray || value instanceof CBORBoolean) {
            return COSEEC2Key.getRawValue(value);
        }
        throw new IllegalArgumentException("y (-3) must be a byte string or a boolean value.");
    }

    private static byte[] validateD(CBORItem value) {
        if (value instanceof CBORByteArray) {
            return (byte[])COSEEC2Key.getRawValue(value);
        }
        throw new IllegalArgumentException("d (-4) must be a byte string.");
    }

    @Override
    public boolean isPrivate() {
        return this.d != null;
    }

    @Override
    public COSEKey toPublic() throws COSEException {
        if (!this.isPrivate()) {
            return this;
        }
        ArrayList<CBORPair> pairs = new ArrayList<CBORPair>();
        for (CBORPair cBORPair : this.getPairs()) {
            if (COSEEC2Key.isPrivatePart(cBORPair)) continue;
            pairs.add(cBORPair);
        }
        return COSEEC2Key.build(new CBORPairList((List<? extends CBORPair>)pairs));
    }

    private static boolean isPrivatePart(CBORPair pair) {
        return COSEEC2Key.isD(pair);
    }

    private static boolean isD(CBORPair pair) {
        CBORItem key = pair.getKey();
        if (!(key instanceof CBORInteger)) {
            return false;
        }
        int label = (Integer)((CBORInteger)key).getValue();
        return label == -4;
    }

    @Override
    protected void addJwkProperties(Map<String, Object> map) {
        if (this.crv != null) {
            map.put("crv", COSEEC2Key.toJwkCrv(this.crv));
        }
        if (this.x != null) {
            map.put("x", COSEEC2Key.encodeByBase64Url(this.x));
        }
        if (this.y != null) {
            map.put("y", COSEEC2Key.toJwkY(this.y));
        }
        if (this.d != null) {
            map.put("d", COSEEC2Key.encodeByBase64Url(this.d));
        }
    }

    private static Object toJwkY(Object y) {
        if (y instanceof byte[]) {
            return COSEEC2Key.encodeByBase64Url((byte[])y);
        }
        return y;
    }

    public Object getCrv() {
        return this.crv;
    }

    public byte[] getX() {
        return this.x;
    }

    public Object getY() {
        return this.y;
    }

    public byte[] getD() {
        return this.d;
    }

    public ECPrivateKey toECPrivateKey() throws COSEException {
        return ECDSA.createPrivateKey(this.crv, this.d);
    }

    public ECPublicKey toECPublicKey() throws COSEException {
        return ECDSA.createPublicKey(this.crv, this.x, this.y);
    }

    @Override
    public PrivateKey createPrivateKey() throws COSEException {
        return this.toECPrivateKey();
    }

    @Override
    public PublicKey createPublicKey() throws COSEException {
        return this.toECPublicKey();
    }

    static void addCoseKtySpecificParameters(CBORPairsBuilder builder, Map<String, Object> jwk) throws COSEException {
        COSEEC2Key.addCoseEC2Crv(builder, jwk);
        COSEEC2Key.addCoseEC2X(builder, jwk);
        COSEEC2Key.addCoseEC2Y(builder, jwk);
        COSEEC2Key.addCoseEC2D(builder, jwk);
    }

    private static void addCoseEC2Crv(CBORPairsBuilder builder, Map<String, Object> jwk) throws COSEException {
        String crv = COSEEC2Key.extractStringProperty(jwk, "crv", false);
        if (crv == null) {
            return;
        }
        int value = COSEEllipticCurves.getValueByName(crv);
        if (value == 0) {
            throw new COSEException(String.format("The curve '%s' is not supported.", crv));
        }
        builder.add(-1, (Object)value);
    }

    private static void addCoseEC2X(CBORPairsBuilder builder, Map<String, Object> jwk) throws COSEException {
        byte[] value = COSEEC2Key.extractBase64UrlProperty(jwk, "x", false);
        builder.addUnlessNull(-2, (Object)value);
    }

    private static void addCoseEC2Y(CBORPairsBuilder builder, Map<String, Object> jwk) throws COSEException {
        byte[] value = COSEEC2Key.extractBase64UrlProperty(jwk, "y", false);
        builder.addUnlessNull(-3, (Object)value);
    }

    private static void addCoseEC2D(CBORPairsBuilder builder, Map<String, Object> jwk) throws COSEException {
        byte[] value = COSEEC2Key.extractBase64UrlProperty(jwk, "d", false);
        builder.addUnlessNull(-4, (Object)value);
    }
}

