/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORItemList;
import com.authlete.cbor.CBORizer;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEMessage;
import com.authlete.cose.COSEMessageType;
import com.authlete.cose.COSEObject;
import com.authlete.cose.COSEProtectedHeader;
import com.authlete.cose.COSERecipient;
import com.authlete.cose.COSEUnprotectedHeader;
import java.util.ArrayList;
import java.util.List;

public class COSEEncrypt
extends COSEMessage {
    public COSEEncrypt(COSEProtectedHeader protectedHeader, COSEUnprotectedHeader unprotectedHeader, CBORItem ciphertext, CBORItemList recipients) {
        super(COSEMessageType.COSE_ENCRYPT, protectedHeader, unprotectedHeader, ciphertext, recipients);
        COSEEncrypt.validateRecipients(recipients);
    }

    private static void validateRecipients(CBORItemList recipients) {
        if (recipients == null) {
            throw new IllegalArgumentException("A recipient list given to COSEEncrypt's constructor must not be null.");
        }
        List<? extends CBORItem> items = recipients.getItems();
        if (items == null || items.size() == 0) {
            throw new IllegalArgumentException("A recipient list given to COSEEncrypt's constructor must not be empty.");
        }
        for (CBORItem cBORItem : items) {
            if (cBORItem instanceof COSERecipient) continue;
            throw new IllegalArgumentException("Items in the recipient list given to COSEEncrypt's constructor must be instances of COSERecipient.");
        }
    }

    public CBORItem getCiphertext() {
        return this.getItems().get(2);
    }

    public CBORItemList getRecipients() {
        return (CBORItemList)this.getItems().get(3);
    }

    public static COSEEncrypt build(CBORItem item) throws COSEException {
        List<CBORItem> common = COSEObject.buildCommon(item, "COSE_Encrypt", 4);
        CBORItem fourth = common.get(3);
        if (!(fourth instanceof CBORItemList)) {
            throw new COSEException("The fourth element (recipients) of COSE_Encrypt must be a CBOR array.");
        }
        CBORItemList recipients = COSEEncrypt.buildRecipients((CBORItemList)fourth);
        try {
            return new COSEEncrypt((COSEProtectedHeader)common.get(0), (COSEUnprotectedHeader)common.get(1), common.get(2), recipients);
        }
        catch (Exception cause) {
            throw new COSEException(cause.getMessage(), cause);
        }
    }

    private static CBORItemList buildRecipients(CBORItemList list) throws COSEException {
        List<? extends CBORItem> items = list.getItems();
        if (items == null || items.size() == 0) {
            throw new COSEException("A list of recipients in COSE_Encrypt must contain at least one recipient.");
        }
        ArrayList<COSERecipient> recipients = new ArrayList<COSERecipient>();
        for (CBORItem cBORItem : items) {
            COSERecipient recipient = COSERecipient.build(cBORItem);
            recipients.add(recipient);
        }
        return new CBORItemList((List<? extends CBORItem>)recipients);
    }

    public static COSEEncrypt build(List<Object> list) throws COSEException {
        return COSEEncrypt.build(new CBORizer().cborizeCollection(list));
    }
}

