/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORInteger;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORItemList;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORPairList;
import com.authlete.cose.constants.COSEAlgorithms;
import com.authlete.cose.constants.COSEHeaderParameters;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class COSEHeaderBuilder<TBuilder extends COSEHeaderBuilder<TBuilder, THeader>, THeader> {
    private final Map<Object, Object> map = new LinkedHashMap<Object, Object>();

    public TBuilder put(Object key, Object value) {
        this.map.put(key, value);
        return (TBuilder)this;
    }

    public TBuilder alg(int alg) {
        return this.put(1, alg);
    }

    public TBuilder alg(String alg) {
        return this.put(1, alg);
    }

    public TBuilder alg(Object alg) {
        return this.put(1, alg);
    }

    public TBuilder crit(List<Object> labels) {
        return this.put(2, labels);
    }

    public TBuilder contentType(String contentType) {
        return this.put(3, contentType);
    }

    public TBuilder contentType(int contentType) {
        return this.put(3, contentType);
    }

    public TBuilder kid(byte[] kid) {
        return this.put(4, kid);
    }

    public TBuilder kid(String kid) {
        byte[] bytes = kid != null ? kid.getBytes(StandardCharsets.UTF_8) : null;
        return this.kid(bytes);
    }

    public TBuilder iv(byte[] iv) {
        return this.put(5, iv);
    }

    public TBuilder partialIv(byte[] partialIv) {
        return this.put(6, partialIv);
    }

    public TBuilder x5chain(List<X509Certificate> chain) throws CertificateEncodingException {
        ArrayList<CBORByteArray> ders = new ArrayList<CBORByteArray>();
        for (X509Certificate cert : chain) {
            ders.add(new CBORByteArray(cert.getEncoded()));
        }
        CBORItem x5chain = 2 <= ders.size() ? new CBORItemList((List<? extends CBORItem>)ders) : (CBORItem)ders.get(0);
        return this.put(33, x5chain);
    }

    public THeader build() {
        return this.build(this.map);
    }

    abstract THeader build(Map<Object, Object> var1);

    static void addHeaderComments(CBORPairList headerParameters) {
        if (headerParameters == null) {
            return;
        }
        List<? extends CBORPair> pairs = headerParameters.getPairs();
        if (pairs == null) {
            return;
        }
        for (CBORPair cBORPair : pairs) {
            COSEHeaderBuilder.addHeaderComment(cBORPair);
        }
    }

    private static void addHeaderComment(CBORPair pair) {
        String algorithmName;
        if (!(pair.getKey() instanceof CBORInteger)) {
            return;
        }
        int identifier = (Integer)((CBORInteger)pair.getKey()).getValue();
        String name = COSEHeaderParameters.getNameByValue(identifier);
        if (name != null) {
            pair.setKeyComment(name);
        }
        if (identifier == 1 && (algorithmName = COSEHeaderBuilder.getAlgorithmName(pair.getValue())) != null) {
            pair.setValueComment(algorithmName);
        }
    }

    private static String getAlgorithmName(CBORItem algorithm) {
        if (!(algorithm instanceof CBORInteger)) {
            return null;
        }
        int identifier = (Integer)((CBORInteger)algorithm).getValue();
        return COSEAlgorithms.getNameByValue(identifier);
    }
}

