/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORBigInteger;
import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORDecoder;
import com.authlete.cbor.CBORInteger;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORItemList;
import com.authlete.cbor.CBORLong;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORPairList;
import com.authlete.cbor.CBORPairsBuilder;
import com.authlete.cbor.CBORString;
import com.authlete.cbor.CBORValue;
import com.authlete.cbor.CBORizer;
import com.authlete.cose.COSEEC2Key;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEOKPKey;
import com.authlete.cose.constants.COSEAlgorithms;
import com.authlete.cose.constants.COSEEllipticCurves;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class COSEKey
extends CBORPairList {
    private Object kty;
    private byte[] kid;
    private Object alg;
    private List<Object> keyOps;
    private byte[] baseIv;

    public COSEKey(List<? extends CBORPair> pairs) {
        super(pairs);
        this.validateParameters(pairs);
    }

    private void validateParameters(List<? extends CBORPair> pairs) {
        for (CBORPair cBORPair : pairs) {
            this.validateParameter(cBORPair);
        }
        if (this.kty == null) {
            throw new IllegalArgumentException("A COSE key must contain kty (1)");
        }
    }

    private void validateParameter(CBORPair pair) {
        Object label;
        CBORItem key = pair.getKey();
        Object object = label = key instanceof CBORString || COSEKey.isInteger(key) ? COSEKey.getRawValue(key) : null;
        if (label == null) {
            throw new IllegalArgumentException("A COSE key label must be an integer or a text string.");
        }
        if (label instanceof Integer) {
            this.validateKnownParameter((Integer)label, pair.getValue());
        }
    }

    private void validateKnownParameter(int label, CBORItem value) {
        switch (label) {
            case 1: {
                this.kty = COSEKey.validateKty(value);
                break;
            }
            case 2: {
                this.kid = COSEKey.validateKid(value);
                break;
            }
            case 3: {
                this.alg = COSEKey.validateAlg(value);
                break;
            }
            case 4: {
                this.keyOps = COSEKey.validateKeyOps(value);
                break;
            }
            case 5: {
                this.baseIv = COSEKey.validateBaseIv(value);
                break;
            }
        }
    }

    static boolean isInteger(CBORItem item) {
        return item instanceof CBORInteger || item instanceof CBORLong || item instanceof CBORBigInteger;
    }

    static Object getRawValue(CBORItem item) {
        return ((CBORValue)item).getValue();
    }

    private static Object validateKty(CBORItem value) {
        if (COSEKey.isInteger(value) || value instanceof CBORString) {
            return COSEKey.getRawValue(value);
        }
        throw new IllegalArgumentException("kty (1) must be an integer or a text string.");
    }

    private static byte[] validateKid(CBORItem value) {
        if (value instanceof CBORByteArray) {
            return (byte[])COSEKey.getRawValue(value);
        }
        throw new IllegalArgumentException("kid (2) must be a byte string.");
    }

    private static Object validateAlg(CBORItem value) {
        if (COSEKey.isInteger(value) || value instanceof CBORString) {
            return COSEKey.getRawValue(value);
        }
        throw new IllegalArgumentException("alg (3) must be an integer or a text string.");
    }

    private static List<Object> validateKeyOps(CBORItem value) {
        if (!(value instanceof CBORItemList)) {
            throw new IllegalArgumentException("key_ops (4) must be a CBOR array.");
        }
        List<? extends CBORItem> items = ((CBORItemList)value).getItems();
        if (items == null || items.size() == 0) {
            throw new IllegalArgumentException("key_ops (4) must have at least one element.");
        }
        for (CBORItem cBORItem : items) {
            if (COSEKey.isInteger(cBORItem) || cBORItem instanceof CBORString) continue;
            throw new IllegalArgumentException("Elements of key_ops (4) must be an integer or a text string.");
        }
        return ((CBORItemList)value).parse();
    }

    private static byte[] validateBaseIv(CBORItem value) {
        if (value instanceof CBORByteArray) {
            return (byte[])COSEKey.getRawValue(value);
        }
        throw new IllegalArgumentException("Base IV (5) must be a byte string.");
    }

    public Map<Object, Object> getParameters() {
        return this.parse();
    }

    public Object getKty() {
        return this.kty;
    }

    public byte[] getKid() {
        return this.kid;
    }

    public Object getAlg() {
        return this.alg;
    }

    public List<Object> getKeyOps() {
        return this.keyOps;
    }

    public byte[] getBaseIv() {
        return this.baseIv;
    }

    public boolean isPrivate() {
        return false;
    }

    public COSEKey toPublic() throws COSEException {
        throw new COSEException("toPublic() is not supported.");
    }

    public PrivateKey createPrivateKey() throws COSEException {
        throw new COSEException("createPrivateKey() is not supported.");
    }

    public PublicKey createPublicKey() throws COSEException {
        throw new COSEException("createPublicKey() is not supported.");
    }

    public COSEKey copy() throws COSEException {
        CBORItem copy;
        try {
            copy = new CBORDecoder(this.encode()).next();
        }
        catch (IOException cause) {
            throw new COSEException(cause);
        }
        return COSEKey.build(copy);
    }

    public Map<String, Object> toJwk() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("kty", COSEKey.toJwkKty(this.kty));
        if (this.alg != null) {
            map.put("alg", COSEKey.toJwkAlg(this.alg));
        }
        if (this.kid != null) {
            map.put("kid", COSEKey.toJwkKid(this.kid));
        }
        if (this.keyOps != null) {
            map.put("key_ops", COSEKey.toJwkKeyOps(this.keyOps));
        }
        this.addJwkProperties(map);
        return map;
    }

    protected void addJwkProperties(Map<String, Object> map) {
    }

    private static String toJwkKty(Object kty) {
        if (kty instanceof String) {
            return (String)kty;
        }
        int identifier = ((Number)kty).intValue();
        switch (identifier) {
            case 1: {
                return "OKP";
            }
            case 2: {
                return "EC";
            }
            case 3: {
                return "RSA";
            }
        }
        return ((Number)kty).toString();
    }

    private static String toJwkAlg(Object alg) {
        if (alg instanceof String) {
            return (String)alg;
        }
        String name = COSEAlgorithms.getNameByValue(((Number)alg).intValue());
        if (name != null) {
            return name;
        }
        return ((Number)alg).toString();
    }

    private static String toJwkKid(byte[] kid) {
        try {
            return COSEKey.buildUtf8String(kid);
        }
        catch (Exception cause) {
            return COSEKey.encodeByBase64Url(kid);
        }
    }

    private static String buildUtf8String(byte[] bytes) throws CharacterCodingException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        return decoder.decode(byteBuffer).toString();
    }

    static String encodeByBase64Url(byte[] bytes) {
        return Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
    }

    private static byte[] decodeByBase64Url(String string) {
        return Base64.getUrlDecoder().decode(string);
    }

    private static List<String> toJwkKeyOps(List<Object> keyOps) {
        ArrayList<String> ops = new ArrayList<String>();
        for (Object keyOp : keyOps) {
            String op = COSEKey.toJwkKeyOp(keyOp);
            if (op == null) continue;
            ops.add(op);
        }
        return ops;
    }

    private static String toJwkKeyOp(Object keyOp) {
        if (keyOp instanceof String) {
            return (String)keyOp;
        }
        int identifier = ((Number)keyOp).intValue();
        switch (identifier) {
            case 1: {
                return "sign";
            }
            case 2: {
                return "verify";
            }
            case 3: {
                return "encrypt";
            }
            case 4: {
                return "decrypt";
            }
            case 5: {
                return "wrapKey";
            }
            case 6: {
                return "unwrapKey";
            }
            case 7: {
                return "deriveKey";
            }
            case 8: {
                return "deriveBits";
            }
        }
        return ((Number)keyOp).toString();
    }

    static String toJwkCrv(Object crv) {
        if (crv instanceof String) {
            return (String)crv;
        }
        String name = COSEEllipticCurves.getNameByValue(((Number)crv).intValue());
        if (name != null) {
            return name;
        }
        return ((Number)crv).toString();
    }

    public static COSEKey build(CBORItem item) throws COSEException {
        if (!(item instanceof CBORPairList)) {
            throw new COSEException("A COSE key must be a CBOR map.");
        }
        List<? extends CBORPair> pairs = ((CBORPairList)item).getPairs();
        if (pairs == null) {
            throw new COSEException("A COSE key must not be empty.");
        }
        Object kty = COSEKey.extractKty(pairs);
        if (kty instanceof Integer) {
            return COSEKey.buildKey((Integer)kty, pairs);
        }
        return COSEKey.buildKey(0, pairs);
    }

    private static Object extractKty(List<? extends CBORPair> pairs) throws COSEException {
        Integer labelKty = 1;
        for (CBORPair cBORPair : pairs) {
            CBORItem key = cBORPair.getKey();
            if (!(key instanceof CBORInteger) || !labelKty.equals(((CBORInteger)key).getValue())) continue;
            try {
                return COSEKey.validateKty(cBORPair.getValue());
            }
            catch (Exception cause) {
                throw new COSEException(cause.getMessage(), cause);
            }
        }
        throw new COSEException("A COSE key must contain the kty (1) parameter.");
    }

    private static COSEKey buildKey(int kty, List<? extends CBORPair> pairs) throws COSEException {
        try {
            switch (kty) {
                case 1: {
                    return new COSEOKPKey(pairs);
                }
                case 2: {
                    return new COSEEC2Key(pairs);
                }
            }
            return new COSEKey(pairs);
        }
        catch (Exception cause) {
            throw new COSEException(cause.getMessage(), cause);
        }
    }

    public static COSEKey build(Map<Object, Object> map) throws COSEException {
        return COSEKey.build(new CBORizer().cborizeMap(map));
    }

    public static COSEKey fromJwk(Map<String, Object> jwk) throws COSEException {
        if (jwk == null) {
            return null;
        }
        CBORPairsBuilder builder = new CBORPairsBuilder();
        int kty = COSEKey.addCoseKty(builder, jwk);
        COSEKey.addCoseKid(builder, jwk);
        COSEKey.addCoseAlg(builder, jwk);
        COSEKey.addCoseKeyOps(builder, jwk);
        COSEKey.addCoseKtySpecificParameters(builder, jwk, kty);
        return COSEKey.build(new CBORPairList(builder.build()));
    }

    private static Object extractProperty(Map<String, Object> jwk, String key, boolean required) throws COSEException {
        Object value = jwk.get(key);
        if (value != null || !required) {
            return value;
        }
        throw new COSEException(String.format("The '%s' property is missing or its value is null.", key));
    }

    static String extractStringProperty(Map<String, Object> jwk, String key, boolean required) throws COSEException {
        Object value = COSEKey.extractProperty(jwk, key, required);
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) {
            throw new COSEException(String.format("The value of the '%s' property is not a string.", key));
        }
        return (String)value;
    }

    private static List<?> extractListProperty(Map<String, Object> jwk, String key, boolean required) throws COSEException {
        Object value = COSEKey.extractProperty(jwk, key, required);
        if (value == null) {
            return null;
        }
        if (!(value instanceof List)) {
            throw new COSEException(String.format("The value of the '%s' property is not an array.", key));
        }
        return (List)value;
    }

    private static List<String> extractStringListProperty(Map<String, Object> jwk, String key, boolean required) throws COSEException {
        List<?> list = COSEKey.extractListProperty(jwk, key, required);
        if (list == null) {
            return null;
        }
        for (Object element2 : list) {
            if (element2 instanceof String) continue;
            throw new COSEException(String.format("The '%s' array contains a non-string element.", key));
        }
        return list.stream().map(element -> (String)element).collect(Collectors.toList());
    }

    static byte[] extractBase64UrlProperty(Map<String, Object> jwk, String key, boolean required) throws COSEException {
        String value = COSEKey.extractStringProperty(jwk, key, required);
        if (value == null) {
            return null;
        }
        return COSEKey.decodeByBase64Url(value);
    }

    private static int addCoseKty(CBORPairsBuilder builder, Map<String, Object> jwk) throws COSEException {
        int value;
        String kty;
        switch (kty = COSEKey.extractStringProperty(jwk, "kty", true)) {
            case "OKP": {
                value = 1;
                break;
            }
            case "EC": {
                value = 2;
                break;
            }
            case "RSA": {
                value = 3;
                break;
            }
            default: {
                throw new COSEException(String.format("The key type '%s' is not supported.", kty));
            }
        }
        builder.add(1, (Object)value);
        return value;
    }

    private static void addCoseKid(CBORPairsBuilder builder, Map<String, Object> jwk) throws COSEException {
        String kid = COSEKey.extractStringProperty(jwk, "kid", false);
        if (kid == null) {
            return;
        }
        byte[] value = kid.getBytes(StandardCharsets.UTF_8);
        builder.add(2, (Object)value);
    }

    private static void addCoseAlg(CBORPairsBuilder builder, Map<String, Object> jwk) throws COSEException {
        String alg = COSEKey.extractStringProperty(jwk, "alg", false);
        if (alg == null) {
            return;
        }
        int value = COSEAlgorithms.getValueByName(alg);
        if (value == 0) {
            throw new COSEException(String.format("The algorithm '%s' is not supported.", alg));
        }
        builder.add(3, (Object)value);
    }

    private static void addCoseKeyOps(CBORPairsBuilder builder, Map<String, Object> jwk) throws COSEException {
        List<String> keyOps = COSEKey.extractStringListProperty(jwk, "key_ops", false);
        if (keyOps == null) {
            return;
        }
        ArrayList<Integer> coseKeyOps = new ArrayList<Integer>();
        for (String keyOp : keyOps) {
            int coseKeyOp = COSEKey.toCoseKeyOp(keyOp);
            if (coseKeyOp == 0) {
                throw new COSEException(String.format("The key operation '%s' is not supported.", keyOp));
            }
            coseKeyOps.add(coseKeyOp);
        }
        builder.add(4, coseKeyOps);
    }

    private static int toCoseKeyOp(String keyOp) {
        switch (keyOp) {
            case "sign": {
                return 1;
            }
            case "verify": {
                return 2;
            }
            case "encrypt": {
                return 3;
            }
            case "decrypt": {
                return 4;
            }
            case "wrapKey": {
                return 5;
            }
            case "unwrapKey": {
                return 6;
            }
            case "deriveKey": {
                return 7;
            }
            case "deriveBits": {
                return 8;
            }
        }
        return 0;
    }

    private static void addCoseKtySpecificParameters(CBORPairsBuilder builder, Map<String, Object> jwk, int kty) throws COSEException {
        switch (kty) {
            case 1: {
                COSEOKPKey.addCoseKtySpecificParameters(builder, jwk);
                break;
            }
            case 2: {
                COSEEC2Key.addCoseKtySpecificParameters(builder, jwk);
                break;
            }
        }
    }
}

