/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORPairList;
import com.authlete.cbor.CBORizer;
import com.authlete.cose.COSEEC2Key;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEKey;
import com.authlete.cose.COSEOKPKey;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class COSEKeyBuilder {
    private static final Base64.Decoder BASE64URL_DECODER = Base64.getUrlDecoder();
    private final Map<Object, Object> map = new LinkedHashMap<Object, Object>();

    private static byte[] decodeBase64Url(String input) {
        return BASE64URL_DECODER.decode(input);
    }

    public COSEKeyBuilder put(Object key, Object value) {
        this.map.put(key, value);
        return this;
    }

    public COSEKeyBuilder kty(String kty) {
        return this.put(1, kty);
    }

    public COSEKeyBuilder kty(int kty) {
        return this.put(1, kty);
    }

    public COSEKeyBuilder ktyOKP() {
        return this.kty(1);
    }

    public COSEKeyBuilder ktyEC2() {
        return this.kty(2);
    }

    public COSEKeyBuilder ktyRSA() {
        return this.kty(3);
    }

    public COSEKeyBuilder ktySymmetric() {
        return this.kty(4);
    }

    public COSEKeyBuilder ktyHSSLMS() {
        return this.kty(5);
    }

    public COSEKeyBuilder ktyWalnutDSA() {
        return this.kty(6);
    }

    public COSEKeyBuilder kid(byte[] kid) {
        return this.put(2, kid);
    }

    public COSEKeyBuilder kid(String kid) {
        byte[] bytes = kid != null ? kid.getBytes(StandardCharsets.UTF_8) : null;
        return this.kid(bytes);
    }

    public COSEKeyBuilder alg(String alg) {
        return this.put(3, alg);
    }

    public COSEKeyBuilder alg(int alg) {
        return this.put(3, alg);
    }

    public COSEKeyBuilder keyOps(List<Object> operations) {
        return this.put(4, operations);
    }

    public COSEKeyBuilder baseIv(byte[] baseIv) {
        return this.put(5, baseIv);
    }

    public COSEKeyBuilder baseIvInBase64Url(String baseIv) {
        return this.baseIv(COSEKeyBuilder.decodeBase64Url(baseIv));
    }

    public COSEKeyBuilder okpCrv(int crv) {
        return this.put(-1, crv);
    }

    public COSEKeyBuilder okpCrv(String crv) {
        return this.put(-1, crv);
    }

    public COSEKeyBuilder okpCrvX25519() {
        return this.okpCrv(4);
    }

    public COSEKeyBuilder okpCrvX448() {
        return this.okpCrv(5);
    }

    public COSEKeyBuilder okpCrvEd25519() {
        return this.okpCrv(6);
    }

    public COSEKeyBuilder okpCrvEd448() {
        return this.okpCrv(7);
    }

    public COSEKeyBuilder okpX(byte[] x) {
        return this.put(-2, x);
    }

    public COSEKeyBuilder okpXInBase64Url(String x) {
        return this.okpX(COSEKeyBuilder.decodeBase64Url(x));
    }

    public COSEKeyBuilder okpD(byte[] d) {
        return this.put(-4, d);
    }

    public COSEKeyBuilder okpDInBase64Url(String d) {
        return this.okpD(COSEKeyBuilder.decodeBase64Url(d));
    }

    public COSEKeyBuilder ec2Crv(int crv) {
        return this.put(-1, crv);
    }

    public COSEKeyBuilder ec2Crv(String crv) {
        return this.put(-1, crv);
    }

    public COSEKeyBuilder ec2CrvP256() {
        return this.ec2Crv(1);
    }

    public COSEKeyBuilder ec2CrvP384() {
        return this.ec2Crv(2);
    }

    public COSEKeyBuilder ec2CrvP521() {
        return this.ec2Crv(3);
    }

    public COSEKeyBuilder ec2CrvSecp256k1() {
        return this.ec2Crv(8);
    }

    public COSEKeyBuilder ec2X(byte[] x) {
        return this.put(-2, x);
    }

    public COSEKeyBuilder ec2XInBase64Url(String x) {
        return this.ec2X(COSEKeyBuilder.decodeBase64Url(x));
    }

    public COSEKeyBuilder ec2Y(byte[] y) {
        return this.put(-3, y);
    }

    public COSEKeyBuilder ec2YInBase64Url(String y) {
        return this.ec2Y(COSEKeyBuilder.decodeBase64Url(y));
    }

    public COSEKeyBuilder ec2Y(boolean y) {
        return this.put(-3, y);
    }

    public COSEKeyBuilder ec2D(byte[] d) {
        return this.put(-4, d);
    }

    public COSEKeyBuilder ec2DInBase64Url(String d) {
        return this.ec2D(COSEKeyBuilder.decodeBase64Url(d));
    }

    public COSEKeyBuilder rsaN(byte[] n) {
        return this.put(-1, n);
    }

    public COSEKeyBuilder rsaNInBase64Url(String n) {
        return this.rsaN(COSEKeyBuilder.decodeBase64Url(n));
    }

    public COSEKeyBuilder rsaE(byte[] e) {
        return this.put(-2, e);
    }

    public COSEKeyBuilder rsaEInBase64Url(String e) {
        return this.rsaE(COSEKeyBuilder.decodeBase64Url(e));
    }

    public COSEKeyBuilder rsaD(byte[] d) {
        return this.put(-3, d);
    }

    public COSEKeyBuilder rsaDInBase64Url(String d) {
        return this.rsaD(COSEKeyBuilder.decodeBase64Url(d));
    }

    public COSEKeyBuilder rsaP(byte[] p) {
        return this.put(-4, p);
    }

    public COSEKeyBuilder rsaPInBase64Url(String p) {
        return this.rsaP(COSEKeyBuilder.decodeBase64Url(p));
    }

    public COSEKeyBuilder rsaQ(byte[] q) {
        return this.put(-5, q);
    }

    public COSEKeyBuilder rsaQInBase64url(String q) {
        return this.rsaQ(COSEKeyBuilder.decodeBase64Url(q));
    }

    public COSEKeyBuilder rsaDP(byte[] dP) {
        return this.put(-6, dP);
    }

    public COSEKeyBuilder rsaDPInBase64Url(String dP) {
        return this.rsaDP(COSEKeyBuilder.decodeBase64Url(dP));
    }

    public COSEKeyBuilder rsaDQ(byte[] dQ) {
        return this.put(-7, dQ);
    }

    public COSEKeyBuilder rsaDQInBase64Url(String dQ) {
        return this.rsaDQ(COSEKeyBuilder.decodeBase64Url(dQ));
    }

    public COSEKeyBuilder rsaQInv(byte[] qInv) {
        return this.put(-8, qInv);
    }

    public COSEKeyBuilder rsaQInvInBase64Url(String qInv) {
        return this.rsaQInv(COSEKeyBuilder.decodeBase64Url(qInv));
    }

    public COSEKeyBuilder rsaOther(List<Object> other) {
        return this.put(-9, other);
    }

    public COSEKeyBuilder rsaRI(byte[] r_i) {
        return this.put(-10, r_i);
    }

    public COSEKeyBuilder rsaRIInBase64Url(String r_i) {
        return this.rsaRI(COSEKeyBuilder.decodeBase64Url(r_i));
    }

    public COSEKeyBuilder rsaDI(byte[] d_i) {
        return this.put(-11, d_i);
    }

    public COSEKeyBuilder rsaDIInBase64Url(String d_i) {
        return this.rsaDI(COSEKeyBuilder.decodeBase64Url(d_i));
    }

    public COSEKeyBuilder rsaTI(byte[] t_i) {
        return this.put(-12, t_i);
    }

    public COSEKeyBuilder rsaTIInBase64Url(String t_i) {
        return this.rsaTI(COSEKeyBuilder.decodeBase64Url(t_i));
    }

    public COSEKeyBuilder symmetricK(byte[] k) {
        return this.put(-1, k);
    }

    public COSEKeyBuilder symmetricKInBase64Url(String k) {
        return this.symmetricK(COSEKeyBuilder.decodeBase64Url(k));
    }

    public COSEKeyBuilder hssLmsPub(byte[] pub) {
        return this.put(-1, pub);
    }

    public COSEKeyBuilder hssLmsPubInBase64Url(String pub) {
        return this.hssLmsPub(COSEKeyBuilder.decodeBase64Url(pub));
    }

    public COSEKeyBuilder walnutDsaN(Number N) {
        return this.put(-1, N);
    }

    public COSEKeyBuilder walnutDsaQ(Number q) {
        return this.put(-2, q);
    }

    public COSEKeyBuilder walnutDsaTValues(List<Number> tValues) {
        return this.put(-3, tValues);
    }

    public COSEKeyBuilder walnutDsaMatrix1(List<List<Number>> matrix1) {
        return this.put(-4, matrix1);
    }

    public COSEKeyBuilder walnutDsaPermutation1(List<Number> permutation1) {
        return this.put(-5, permutation1);
    }

    public COSEKeyBuilder walnutDsaMatrix2(List<List<Number>> matrix2) {
        return this.put(-6, matrix2);
    }

    private List<? extends CBORPair> toPairs() {
        return ((CBORPairList)new CBORizer().cborizeMap(this.map)).getPairs();
    }

    public COSEOKPKey buildOKPKey() {
        return new COSEOKPKey(this.toPairs());
    }

    public COSEEC2Key buildEC2Key() {
        return new COSEEC2Key(this.toPairs());
    }

    public COSEKey build() throws COSEException {
        return COSEKey.build(this.map);
    }
}

