/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORItemList;
import com.authlete.cbor.CBORizer;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEMessage;
import com.authlete.cose.COSEMessageType;
import com.authlete.cose.COSEObject;
import com.authlete.cose.COSEProtectedHeader;
import com.authlete.cose.COSERecipient;
import com.authlete.cose.COSEUnprotectedHeader;
import java.util.ArrayList;
import java.util.List;

public class COSEMac
extends COSEMessage {
    public COSEMac(COSEProtectedHeader protectedHeader, COSEUnprotectedHeader unprotectedHeader, CBORItem payload, CBORByteArray tag, CBORItemList recipients) {
        super(COSEMessageType.COSE_MAC, protectedHeader, unprotectedHeader, payload, tag, recipients);
        COSEMac.validateTag(tag);
        COSEMac.validateRecipients(recipients);
    }

    private static void validateTag(CBORByteArray tag) {
        if (tag == null) {
            throw new IllegalArgumentException("A tag given to COSEMac's constructor must not be null.");
        }
    }

    private static void validateRecipients(CBORItemList recipients) {
        if (recipients == null) {
            throw new IllegalArgumentException("A recipient list given to COSEMac's constructor must not be null.");
        }
        List<? extends CBORItem> items = recipients.getItems();
        if (items == null || items.size() == 0) {
            throw new IllegalArgumentException("A recipient list given to COSEMac's constructor must not be empty.");
        }
        for (CBORItem cBORItem : items) {
            if (cBORItem instanceof COSERecipient) continue;
            throw new IllegalArgumentException("Items in the recipient list given to COSEMac's constructor must be instances of COSERecipient.");
        }
    }

    public CBORItem getPayload() {
        return this.getItems().get(2);
    }

    public CBORByteArray getTag() {
        return (CBORByteArray)this.getItems().get(3);
    }

    public CBORItemList getRecipients() {
        return (CBORItemList)this.getItems().get(4);
    }

    public static COSEMac build(CBORItem item) throws COSEException {
        List<CBORItem> common = COSEObject.buildCommon(item, "COSE_Mac", 5);
        CBORItem fourth = common.get(3);
        if (!(fourth instanceof CBORByteArray)) {
            throw new COSEException("The fourth element (tag) of COSE_Mac must be a byte string.");
        }
        CBORItem fifth = common.get(4);
        if (!(fifth instanceof CBORItemList)) {
            throw new COSEException("The fifth element (recipients) of COSE_Mac must be a CBOR array.");
        }
        CBORItemList recipients = COSEMac.buildRecipients((CBORItemList)fourth);
        try {
            return new COSEMac((COSEProtectedHeader)common.get(0), (COSEUnprotectedHeader)common.get(1), common.get(2), (CBORByteArray)fourth, recipients);
        }
        catch (Exception cause) {
            throw new COSEException(cause.getMessage(), cause);
        }
    }

    private static CBORItemList buildRecipients(CBORItemList list) throws COSEException {
        List<? extends CBORItem> items = list.getItems();
        if (items == null || items.size() == 0) {
            throw new COSEException("A list of recipients in COSE_Mac must contain at least one recipient.");
        }
        ArrayList<COSERecipient> recipients = new ArrayList<COSERecipient>();
        for (CBORItem cBORItem : items) {
            COSERecipient recipient = COSERecipient.build(cBORItem);
            recipients.add(recipient);
        }
        return new CBORItemList((List<? extends CBORItem>)recipients);
    }

    public static COSEMac build(List<Object> list) throws COSEException {
        return COSEMac.build(new CBORizer().cborizeCollection(list));
    }
}

