/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORizer;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEMessage;
import com.authlete.cose.COSEMessageType;
import com.authlete.cose.COSEObject;
import com.authlete.cose.COSEProtectedHeader;
import com.authlete.cose.COSEUnprotectedHeader;
import java.util.List;

public class COSEMac0
extends COSEMessage {
    public COSEMac0(COSEProtectedHeader protectedHeader, COSEUnprotectedHeader unprotectedHeader, CBORItem payload, CBORByteArray tag) {
        super(COSEMessageType.COSE_MAC0, protectedHeader, unprotectedHeader, payload, tag);
        COSEMac0.validateTag(tag);
    }

    private static void validateTag(CBORByteArray tag) {
        if (tag == null) {
            throw new IllegalArgumentException("A tag given to COSEMac0's constructor must not be null.");
        }
    }

    public CBORItem getPayload() {
        return this.getItems().get(2);
    }

    public CBORByteArray getTag() {
        return (CBORByteArray)this.getItems().get(3);
    }

    public static COSEMac0 build(CBORItem item) throws COSEException {
        List<CBORItem> common = COSEObject.buildCommon(item, "COSE_Mac0", 4);
        CBORItem fourth = common.get(3);
        if (!(fourth instanceof CBORByteArray)) {
            throw new COSEException("The fourth element (tag) of COSE_Mac0 must be a byte string.");
        }
        try {
            return new COSEMac0((COSEProtectedHeader)common.get(0), (COSEUnprotectedHeader)common.get(1), common.get(2), (CBORByteArray)fourth);
        }
        catch (Exception cause) {
            throw new COSEException(cause.getMessage(), cause);
        }
    }

    public static COSEMac0 build(List<Object> list) throws COSEException {
        return COSEMac0.build(new CBORizer().cborizeCollection(list));
    }
}

