/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORTaggedItem;
import com.authlete.cose.COSEMessageType;
import com.authlete.cose.COSEObject;
import com.authlete.cose.COSEProtectedHeader;
import com.authlete.cose.COSEUnprotectedHeader;

public abstract class COSEMessage
extends COSEObject {
    private final COSEMessageType type;

    public COSEMessage(COSEMessageType type, COSEProtectedHeader protectedHeader, COSEUnprotectedHeader unprotectedHeader, CBORItem content, CBORItem ... additionalItems) throws IllegalArgumentException {
        super(protectedHeader, unprotectedHeader, content, additionalItems);
        if (type == null) {
            throw new IllegalArgumentException("The COSE message type is missing.");
        }
        this.type = type;
        this.setComment(type.getName());
    }

    public COSEMessageType getType() {
        return this.type;
    }

    public int getTagNumber() {
        return this.getType().getTagNumber();
    }

    public CBORTaggedItem getTagged() {
        return new CBORTaggedItem(this.getTagNumber(), this);
    }
}

