/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORDecoderException;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.tag.CBORTagProcessor;
import com.authlete.cose.COSEEncrypt;
import com.authlete.cose.COSEEncrypt0;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEMac;
import com.authlete.cose.COSEMac0;
import com.authlete.cose.COSEMessage;
import com.authlete.cose.COSESign;
import com.authlete.cose.COSESign1;

public class COSEMessageTagProcessor
implements CBORTagProcessor {
    public static COSEMessageTagProcessor INSTANCE = new COSEMessageTagProcessor();

    @Override
    public CBORItem process(Number tagNumber, CBORItem tagContent) throws CBORDecoderException {
        COSEMessage message;
        int tag = tagNumber.intValue();
        try {
            message = COSEMessageTagProcessor.buildMessage(tag, tagContent);
        }
        catch (Exception cause) {
            throw new CBORDecoderException(String.format("The CBOR data item following the tag number '%s' failed to be parsed as a COSE message: %s", tagNumber.toString(), cause.getMessage()), cause);
        }
        if (message == null) {
            throw new CBORDecoderException(String.format("%s has been registered for the wrong tag number '%s'.", this.getClass().getSimpleName(), tagNumber.toString()));
        }
        return message.getTagged();
    }

    private static COSEMessage buildMessage(int tag, CBORItem item) throws COSEException {
        switch (tag) {
            case 16: {
                return COSEEncrypt0.build(item);
            }
            case 17: {
                return COSEMac0.build(item);
            }
            case 18: {
                return COSESign1.build(item);
            }
            case 96: {
                return COSEEncrypt.build(item);
            }
            case 97: {
                return COSEMac.build(item);
            }
            case 98: {
                return COSESign.build(item);
            }
        }
        return null;
    }
}

