/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORPairsBuilder;
import com.authlete.cbor.CBORString;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEKey;
import com.authlete.cose.constants.COSEEllipticCurves;
import java.util.List;
import java.util.Map;

public class COSEOKPKey
extends COSEKey {
    private Object crv;
    private byte[] x;
    private byte[] d;

    public COSEOKPKey(List<? extends CBORPair> pairs) {
        super(pairs);
        this.validateParameters(pairs);
    }

    private void validateParameters(List<? extends CBORPair> pairs) {
        for (CBORPair cBORPair : pairs) {
            this.validateParameter(cBORPair);
        }
    }

    private void validateParameter(CBORPair pair) {
        CBORItem label = pair.getKey();
        if (!(label instanceof Integer)) {
            return;
        }
        this.validateKnownParameter((Integer)((Object)label), pair.getValue());
    }

    private void validateKnownParameter(int label, CBORItem value) {
        switch (label) {
            case -1: {
                this.crv = COSEOKPKey.validateCrv(value);
                break;
            }
            case -2: {
                this.x = COSEOKPKey.validateX(value);
                break;
            }
            case -4: {
                this.d = COSEOKPKey.validateD(value);
                break;
            }
        }
    }

    private static Object validateCrv(CBORItem value) {
        if (COSEOKPKey.isInteger(value) || value instanceof CBORString) {
            return COSEOKPKey.getRawValue(value);
        }
        throw new IllegalArgumentException("crv (-1) must be an integer or a text string.");
    }

    private static byte[] validateX(CBORItem value) {
        if (value instanceof CBORByteArray) {
            return (byte[])COSEOKPKey.getRawValue(value);
        }
        throw new IllegalArgumentException("x (-2) must be a byte string.");
    }

    private static byte[] validateD(CBORItem value) {
        if (value instanceof CBORByteArray) {
            return (byte[])COSEOKPKey.getRawValue(value);
        }
        throw new IllegalArgumentException("d (-4) must be a byte string.");
    }

    @Override
    public boolean isPrivate() {
        return this.d != null;
    }

    @Override
    protected void addJwkProperties(Map<String, Object> map) {
        if (this.crv != null) {
            map.put("crv", COSEOKPKey.toJwkCrv(this.crv));
        }
        if (this.x != null) {
            map.put("x", COSEOKPKey.encodeByBase64Url(this.x));
        }
        if (this.d != null) {
            map.put("d", COSEOKPKey.encodeByBase64Url(this.d));
        }
    }

    public Object getCrv() {
        return this.crv;
    }

    public byte[] getX() {
        return this.x;
    }

    public byte[] getD() {
        return this.d;
    }

    static void addCoseKtySpecificParameters(CBORPairsBuilder builder, Map<String, Object> jwk) throws COSEException {
        COSEOKPKey.addCoseOKPCrv(builder, jwk);
        COSEOKPKey.addCoseOKPX(builder, jwk);
        COSEOKPKey.addCoseOKPD(builder, jwk);
    }

    private static void addCoseOKPCrv(CBORPairsBuilder builder, Map<String, Object> jwk) throws COSEException {
        String crv = COSEOKPKey.extractStringProperty(jwk, "crv", false);
        if (crv == null) {
            return;
        }
        int value = COSEEllipticCurves.getValueByName(crv);
        if (value == 0) {
            throw new COSEException(String.format("The curve '%s' is not supported.", crv));
        }
        builder.add(-1, (Object)value);
    }

    private static void addCoseOKPX(CBORPairsBuilder builder, Map<String, Object> jwk) throws COSEException {
        byte[] value = COSEOKPKey.extractBase64UrlProperty(jwk, "x", false);
        builder.addUnlessNull(-2, (Object)value);
    }

    private static void addCoseOKPD(CBORPairsBuilder builder, Map<String, Object> jwk) throws COSEException {
        byte[] value = COSEOKPKey.extractBase64UrlProperty(jwk, "d", false);
        builder.addUnlessNull(-4, (Object)value);
    }
}

