/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORItemList;
import com.authlete.cbor.CBORNull;
import com.authlete.cbor.CBORTaggedItem;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEProtectedHeader;
import com.authlete.cose.COSEUnprotectedHeader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class COSEObject
extends CBORItemList {
    public COSEObject(COSEProtectedHeader protectedHeader, COSEUnprotectedHeader unprotectedHeader, CBORItem content, CBORItem ... additionalItems) throws IllegalArgumentException {
        super(COSEObject.buildItems(protectedHeader, unprotectedHeader, content, additionalItems));
        COSEObject.validateProtectedHeader(protectedHeader);
        COSEObject.validateUnprotectedHeader(unprotectedHeader);
        COSEObject.validateContent(content);
    }

    private static List<CBORItem> buildItems(COSEProtectedHeader protectedHeader, COSEUnprotectedHeader unprotectedHeader, CBORItem content, CBORItem ... additionalItems) {
        ArrayList<CBORItem> items = new ArrayList<CBORItem>();
        items.add(protectedHeader);
        items.add(unprotectedHeader);
        items.add(content);
        for (CBORItem item : additionalItems) {
            items.add(item);
        }
        return items;
    }

    private static void validateProtectedHeader(COSEProtectedHeader header) {
        if (header == null) {
            throw new IllegalArgumentException("A protected header given to the constructor must not be null.");
        }
    }

    private static void validateUnprotectedHeader(COSEUnprotectedHeader header) {
        if (header == null) {
            throw new IllegalArgumentException("A unprotected header given to the constructor must not be null.");
        }
    }

    private static void validateContent(CBORItem content) {
        while (content instanceof CBORTaggedItem) {
            content = ((CBORTaggedItem)content).getTagContent();
        }
        if (content instanceof CBORByteArray || content instanceof CBORNull) {
            return;
        }
        throw new IllegalArgumentException("A content given to the constructor must be an instance of either CBORByteArray or CBORNull.");
    }

    public COSEProtectedHeader getProtectedHeader() {
        return (COSEProtectedHeader)this.getItems().get(0);
    }

    public COSEUnprotectedHeader getUnprotectedHeader() {
        return (COSEUnprotectedHeader)this.getItems().get(1);
    }

    static List<CBORItem> buildCommon(CBORItem object, String name) throws COSEException {
        return COSEObject.buildCommon(object, name, 0);
    }

    static List<CBORItem> buildCommon(CBORItem object, String name, int size) throws COSEException {
        List<? extends CBORItem> elements = COSEObject.extractElements(object, name, size);
        COSEProtectedHeader protectedHeader = COSEProtectedHeader.build(elements.get(0));
        COSEUnprotectedHeader unprotectedHeader = COSEUnprotectedHeader.build(elements.get(1));
        COSEObject.checkLabelDuplicates(protectedHeader, unprotectedHeader);
        CBORItem content = COSEObject.checkContent(elements.get(2), name);
        ArrayList<CBORItem> validated = new ArrayList<CBORItem>();
        validated.add(protectedHeader);
        validated.add(unprotectedHeader);
        validated.add(content);
        for (int i = 3; i < size; ++i) {
            validated.add(elements.get(i));
        }
        return validated;
    }

    private static List<? extends CBORItem> extractElements(CBORItem object, String name, int size) throws COSEException {
        if (!(object instanceof CBORItemList)) {
            throw new COSEException(String.format("%s must be a CBOR array.", name));
        }
        List<? extends CBORItem> elements = ((CBORItemList)object).getItems();
        if (elements == null) {
            throw new COSEException(String.format("A CBOR array that represents %s must not be empty.", name));
        }
        if (0 < size) {
            if (elements.size() != size) {
                throw new COSEException(String.format("The size of a CBOR array that represents %s must be %d.", name, size));
            }
        } else if (elements.size() < 3) {
            throw new COSEException(String.format("A CBOR array that represents %s must have at least 3 elements.", name));
        }
        return elements;
    }

    private static void checkLabelDuplicates(COSEProtectedHeader protectedHeader, COSEUnprotectedHeader unprotectedHeader) throws COSEException {
        Set<Object> protectedLabels = protectedHeader.getParameters().keySet();
        Set<Object> unprotectedLabels = unprotectedHeader.getParameters().keySet();
        int cmp = Integer.compare(protectedLabels.size(), unprotectedLabels.size());
        Set<Object> set1 = cmp <= 0 ? protectedLabels : unprotectedLabels;
        Set<Object> set2 = cmp > 0 ? protectedLabels : unprotectedLabels;
        for (Object element : set1) {
            if (!set2.contains(element)) continue;
            throw new COSEException(String.format("The label '%s' exists in both the protected header and the unprotected header.", element.toString()));
        }
    }

    private static CBORItem checkContent(CBORItem content, String name) throws COSEException {
        if (content instanceof CBORByteArray || content instanceof CBORNull) {
            return content;
        }
        throw new COSEException(String.format("The third element of %s must be a byte array or null.", name));
    }
}

