/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORDecoder;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORPairList;
import com.authlete.cbor.CBORizer;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEHeaderBuilder;
import com.authlete.cose.HeaderValidator;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class COSEProtectedHeader
extends CBORByteArray {
    private final List<? extends CBORPair> pairs;
    private Object alg;
    private List<Object> crit;
    private Object contentType;
    private byte[] kid;
    private byte[] iv;
    private byte[] partialIv;
    private List<X509Certificate> x5chain;

    public COSEProtectedHeader(byte[] value) {
        this(value, (List<? extends CBORPair>)null);
    }

    public COSEProtectedHeader(byte[] value, List<? extends CBORPair> pairs) throws IllegalArgumentException {
        super(value, new CBORPairList(pairs));
        this.validateParameters(pairs);
        this.pairs = pairs;
        this.setComment("protected");
    }

    private void validateParameters(List<? extends CBORPair> pairs) {
        Map<Object, Object> map = HeaderValidator.validate(pairs, false);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object label = entry.getKey();
            if (!(label instanceof Integer)) continue;
            this.initializeField((Integer)label, entry.getValue());
        }
    }

    private void initializeField(int label, Object value) {
        switch (label) {
            case 1: {
                this.alg = value;
                break;
            }
            case 2: {
                this.crit = (List)value;
                break;
            }
            case 3: {
                this.contentType = value;
                break;
            }
            case 4: {
                this.kid = (byte[])value;
                break;
            }
            case 5: {
                this.iv = (byte[])value;
                break;
            }
            case 6: {
                this.partialIv = (byte[])value;
                break;
            }
            case 33: {
                this.x5chain = (List)value;
                break;
            }
        }
    }

    public List<? extends CBORPair> getPairs() {
        return this.pairs;
    }

    public Map<Object, Object> getParameters() {
        return new CBORPairList(this.pairs).parse();
    }

    public Object getAlg() {
        return this.alg;
    }

    public List<Object> getCrit() {
        return this.crit;
    }

    public Object getContentType() {
        return this.contentType;
    }

    public byte[] getKid() {
        return this.kid;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public byte[] getPartialIv() {
        return this.partialIv;
    }

    public List<X509Certificate> getX5Chain() {
        return this.x5chain;
    }

    public static COSEProtectedHeader build(CBORItem header) throws COSEException {
        if (!(header instanceof CBORByteArray)) {
            throw new COSEException("A protected header must be a byte string.");
        }
        byte[] bytes = (byte[])((CBORByteArray)header).getValue();
        if (bytes.length == 0) {
            return new COSEProtectedHeader(bytes);
        }
        CBORDecoder decoder = new CBORDecoder(bytes);
        CBORItem item = COSEProtectedHeader.next(decoder);
        if (!(item instanceof CBORPairList)) {
            throw new COSEException("The content of a byte string that represents a protected header must be a CBOR map.");
        }
        if (COSEProtectedHeader.next(decoder) != null) {
            throw new COSEException("The content of the byte string that represents a protected header must not contain redundant CBOR data items.");
        }
        List<? extends CBORPair> pairs = ((CBORPairList)item).getPairs();
        if (pairs.size() == 0) {
            return new COSEProtectedHeader(new byte[0]);
        }
        try {
            return new COSEProtectedHeader(bytes, pairs);
        }
        catch (Exception cause) {
            throw new COSEException(cause.getMessage(), cause);
        }
    }

    private static CBORItem next(CBORDecoder decoder) throws COSEException {
        try {
            return decoder.next();
        }
        catch (IOException cause) {
            throw new COSEException(cause.getMessage(), cause);
        }
    }

    public static COSEProtectedHeader build(Map<Object, Object> map) {
        if (map == null) {
            map = Collections.emptyMap();
        }
        CBORPairList pairList = (CBORPairList)new CBORizer().cborizeMap(map);
        COSEHeaderBuilder.addHeaderComments(pairList);
        byte[] value = pairList.encode();
        return new COSEProtectedHeader(value, pairList.getPairs());
    }
}

