/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORItemList;
import com.authlete.cbor.CBORizer;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEObject;
import com.authlete.cose.COSEProtectedHeader;
import com.authlete.cose.COSEUnprotectedHeader;
import java.util.ArrayList;
import java.util.List;

public class COSERecipient
extends COSEObject {
    public COSERecipient(COSEProtectedHeader protectedHeader, COSEUnprotectedHeader unprotectedHeader, CBORItem ciphertext) {
        super(protectedHeader, unprotectedHeader, ciphertext, new CBORItem[0]);
    }

    public COSERecipient(COSEProtectedHeader protectedHeader, COSEUnprotectedHeader unprotectedHeader, CBORItem ciphertext, CBORItemList recipients) {
        super(protectedHeader, unprotectedHeader, ciphertext, new CBORItem[]{recipients});
        COSERecipient.validateRecipients(recipients);
    }

    private static void validateRecipients(CBORItemList recipients) {
        if (recipients == null) {
            throw new IllegalArgumentException("A recipient list given to COSERecipient's constructor must not be null.");
        }
        List<? extends CBORItem> items = recipients.getItems();
        if (items == null || items.size() == 0) {
            throw new IllegalArgumentException("A recipient list given to COSERecipient's constructor must not be empty.");
        }
        for (CBORItem cBORItem : items) {
            if (cBORItem instanceof COSERecipient) continue;
            throw new IllegalArgumentException("Items in the recipient list given to COSERecipient's constructor must be instances of COSERecipient.");
        }
    }

    public CBORItem getCiphertext() {
        return this.getItems().get(2);
    }

    public CBORItemList getRecipients() {
        if (this.getItems().size() <= 3) {
            return null;
        }
        return (CBORItemList)this.getItems().get(3);
    }

    public static COSERecipient build(CBORItem item) throws COSEException {
        List<CBORItem> common = COSEObject.buildCommon(item, "COSE_recipient");
        if (common.size() == 3) {
            return new COSERecipient((COSEProtectedHeader)common.get(0), (COSEUnprotectedHeader)common.get(1), common.get(2));
        }
        CBORItem fourth = common.get(3);
        if (!(fourth instanceof CBORItemList)) {
            throw new COSEException("The fourth element (recipients) of COSE_recipient must be a CBOR array.");
        }
        CBORItemList recipients = COSERecipient.buildRecipients((CBORItemList)fourth);
        try {
            return new COSERecipient((COSEProtectedHeader)common.get(0), (COSEUnprotectedHeader)common.get(1), common.get(2), recipients);
        }
        catch (Exception cause) {
            throw new COSEException(cause.getMessage(), cause);
        }
    }

    private static CBORItemList buildRecipients(CBORItemList list) throws COSEException {
        List<? extends CBORItem> items = list.getItems();
        if (items == null || items.size() == 0) {
            throw new COSEException("A list of recipients in COSE_recipient must contain at least one recipient.");
        }
        ArrayList<COSERecipient> recipients = new ArrayList<COSERecipient>();
        for (CBORItem cBORItem : items) {
            COSERecipient recipient = COSERecipient.build(cBORItem);
            recipients.add(recipient);
        }
        return new CBORItemList((List<? extends CBORItem>)recipients);
    }

    public static COSERecipient build(List<Object> list) throws COSEException {
        return COSERecipient.build(new CBORizer().cborizeCollection(list));
    }
}

