/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORItemList;
import com.authlete.cbor.CBORizer;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEMessage;
import com.authlete.cose.COSEMessageType;
import com.authlete.cose.COSEObject;
import com.authlete.cose.COSEProtectedHeader;
import com.authlete.cose.COSESignature;
import com.authlete.cose.COSEUnprotectedHeader;
import java.util.ArrayList;
import java.util.List;

public class COSESign
extends COSEMessage {
    public COSESign(COSEProtectedHeader protectedHeader, COSEUnprotectedHeader unprotectedHeader, CBORItem payload, CBORItemList signatures) {
        super(COSEMessageType.COSE_SIGN, protectedHeader, unprotectedHeader, payload, signatures);
        COSESign.validateSignatures(signatures);
    }

    private static void validateSignatures(CBORItemList signatures) {
        if (signatures == null) {
            throw new IllegalArgumentException("A signature list given to COSESign's constructor must not be null.");
        }
        List<? extends CBORItem> items = signatures.getItems();
        if (items == null || items.size() == 0) {
            throw new IllegalArgumentException("A signature list given to COSESign's constructor must not be empty.");
        }
        for (CBORItem cBORItem : items) {
            if (cBORItem instanceof COSESignature) continue;
            throw new IllegalArgumentException("Items in the signature list given to COSESign's constructor must be instances of COSESignature.");
        }
    }

    public CBORItem getPayload() {
        return this.getItems().get(2);
    }

    public CBORItemList getSignatures() {
        return (CBORItemList)this.getItems().get(3);
    }

    public static COSESign build(CBORItem item) throws COSEException {
        List<CBORItem> common = COSEObject.buildCommon(item, "COSE_Sign", 4);
        CBORItem fourth = common.get(3);
        if (!(fourth instanceof CBORItemList)) {
            throw new COSEException("The fourth element (signatures) of COSE_Sign must be a CBOR array.");
        }
        CBORItemList signatures = COSESign.buildSignatures((CBORItemList)fourth);
        try {
            return new COSESign((COSEProtectedHeader)common.get(0), (COSEUnprotectedHeader)common.get(1), common.get(2), signatures);
        }
        catch (Exception cause) {
            throw new COSEException(cause.getMessage(), cause);
        }
    }

    private static CBORItemList buildSignatures(CBORItemList list) throws COSEException {
        List<? extends CBORItem> items = list.getItems();
        if (items == null || items.size() == 0) {
            throw new COSEException("COSE_Sign must contain at least one signature.");
        }
        ArrayList<COSESignature> signatures = new ArrayList<COSESignature>();
        for (CBORItem cBORItem : items) {
            COSESignature signature = COSESignature.build(cBORItem);
            signatures.add(signature);
        }
        return new CBORItemList((List<? extends CBORItem>)signatures);
    }

    public static COSESign build(List<Object> list) throws COSEException {
        return COSESign.build(new CBORizer().cborizeCollection(list));
    }
}

