/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORizer;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEMessage;
import com.authlete.cose.COSEMessageType;
import com.authlete.cose.COSEObject;
import com.authlete.cose.COSEProtectedHeader;
import com.authlete.cose.COSEUnprotectedHeader;
import java.util.List;

public class COSESign1
extends COSEMessage {
    public COSESign1(COSEProtectedHeader protectedHeader, COSEUnprotectedHeader unprotectedHeader, CBORItem payload, CBORByteArray signature) {
        super(COSEMessageType.COSE_SIGN1, protectedHeader, unprotectedHeader, payload, signature);
        COSESign1.validateSignature(signature);
    }

    private static void validateSignature(CBORByteArray signature) {
        if (signature == null) {
            throw new IllegalArgumentException("A signature given to COSESign1's constructor must not be null.");
        }
    }

    public CBORItem getPayload() {
        return this.getItems().get(2);
    }

    public CBORByteArray getSignature() {
        return (CBORByteArray)this.getItems().get(3);
    }

    public static COSESign1 build(CBORItem item) throws COSEException {
        List<CBORItem> common = COSEObject.buildCommon(item, "COSE_Sign1", 4);
        CBORItem signature = common.get(3);
        if (!(signature instanceof CBORByteArray)) {
            throw new COSEException("The fourth element (signature) of COSE_Sign1 must be a byte string.");
        }
        try {
            return new COSESign1((COSEProtectedHeader)common.get(0), (COSEUnprotectedHeader)common.get(1), common.get(2), (CBORByteArray)signature);
        }
        catch (Exception cause) {
            throw new COSEException(cause.getMessage(), cause);
        }
    }

    public static COSESign1 build(List<Object> list) throws COSEException {
        return COSESign1.build(new CBORizer().cborizeCollection(list));
    }
}

