/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORNull;
import com.authlete.cose.COSEProtectedHeader;
import com.authlete.cose.COSESign1;
import com.authlete.cose.COSEUnprotectedHeader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;

public class COSESign1Builder {
    private COSEProtectedHeader protectedHeader;
    private COSEUnprotectedHeader unprotectedHeader;
    private CBORItem payload;
    private CBORByteArray signature;

    public COSESign1Builder protectedHeader(COSEProtectedHeader header) {
        this.protectedHeader = header;
        return this;
    }

    public COSESign1Builder unprotectedHeader(COSEUnprotectedHeader header) {
        this.unprotectedHeader = header;
        return this;
    }

    public COSESign1Builder payload(CBORByteArray payload) {
        this.payload = payload;
        return this;
    }

    public COSESign1Builder payload(byte[] payload) {
        CBORByteArray ba = payload != null ? new CBORByteArray(payload) : null;
        return this.payload(ba);
    }

    public COSESign1Builder payload(CBORItem payload) {
        this.payload = payload;
        return this;
    }

    public COSESign1Builder payload(String payload) {
        byte[] bytes = payload != null ? payload.getBytes(StandardCharsets.UTF_8) : null;
        return this.payload(bytes);
    }

    public COSESign1Builder signature(CBORByteArray signature) {
        this.signature = signature;
        return this;
    }

    public COSESign1Builder signature(byte[] signature) {
        CBORByteArray ba;
        CBORByteArray cBORByteArray = ba = signature != null ? new CBORByteArray(signature) : null;
        if (ba != null) {
            ba.setComment("signature");
        }
        return this.signature(ba);
    }

    public COSESign1 build() throws IllegalStateException {
        if (this.signature == null) {
            throw new IllegalStateException("Signature is not set.");
        }
        if (this.protectedHeader == null) {
            this.protectedHeader = new COSEProtectedHeader(new byte[0]);
        }
        if (this.unprotectedHeader == null) {
            this.unprotectedHeader = new COSEUnprotectedHeader(Collections.emptyList());
        }
        if (this.payload == null) {
            this.payload = CBORNull.INSTANCE;
        }
        return new COSESign1(this.protectedHeader, this.unprotectedHeader, this.payload, this.signature);
    }
}

