/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORItemList;
import com.authlete.cbor.CBORNull;
import com.authlete.cose.COSEProtectedHeader;
import com.authlete.cose.COSESign;
import com.authlete.cose.COSESignature;
import com.authlete.cose.COSEUnprotectedHeader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class COSESignBuilder {
    private COSEProtectedHeader protectedHeader;
    private COSEUnprotectedHeader unprotectedHeader;
    private CBORItem payload;
    private List<CBORItem> signatures = new ArrayList<CBORItem>();

    public COSESignBuilder protectedHeader(COSEProtectedHeader header) {
        this.protectedHeader = header;
        return this;
    }

    public COSESignBuilder unprotectedHeader(COSEUnprotectedHeader header) {
        this.unprotectedHeader = header;
        return this;
    }

    public COSESignBuilder payload(CBORByteArray payload) {
        this.payload = payload;
        return this;
    }

    public COSESignBuilder payload(byte[] payload) {
        CBORByteArray ba = payload != null ? new CBORByteArray(payload) : null;
        return this.payload(ba);
    }

    public COSESignBuilder payload(String payload) {
        byte[] bytes = payload != null ? payload.getBytes(StandardCharsets.UTF_8) : null;
        return this.payload(bytes);
    }

    public COSESignBuilder payload(CBORItem payload) {
        this.payload = payload;
        return this;
    }

    public COSESignBuilder signature(COSESignature signature) {
        this.signatures.add(signature);
        return this;
    }

    public COSESign build() throws IllegalStateException {
        if (this.signatures.size() == 0) {
            throw new IllegalStateException("The signature(COSESignature) method must be called at least once.");
        }
        if (this.protectedHeader == null) {
            this.protectedHeader = new COSEProtectedHeader(new byte[0]);
        }
        if (this.unprotectedHeader == null) {
            this.unprotectedHeader = new COSEUnprotectedHeader(Collections.emptyList());
        }
        if (this.payload == null) {
            this.payload = CBORNull.INSTANCE;
        }
        return new COSESign(this.protectedHeader, this.unprotectedHeader, this.payload, new CBORItemList(this.signatures));
    }
}

