/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORizer;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEObject;
import com.authlete.cose.COSEProtectedHeader;
import com.authlete.cose.COSEUnprotectedHeader;
import java.util.List;

public class COSESignature
extends COSEObject {
    public COSESignature(COSEProtectedHeader protectedHeader, COSEUnprotectedHeader unprotectedHeader, byte[] signature) {
        this(protectedHeader, unprotectedHeader, new CBORByteArray(signature));
    }

    public COSESignature(COSEProtectedHeader protectedHeader, COSEUnprotectedHeader unprotectedHeader, CBORByteArray signature) {
        super(protectedHeader, unprotectedHeader, signature, new CBORItem[0]);
        COSESignature.validateSignature(signature);
    }

    private static void validateSignature(CBORByteArray signature) {
        if (signature == null) {
            throw new IllegalArgumentException("A signature given to COSESignature's constructor must not be null.");
        }
    }

    public CBORByteArray getSignature() {
        return (CBORByteArray)this.getItems().get(2);
    }

    public static COSESignature build(CBORItem item) throws COSEException {
        List<CBORItem> common = COSEObject.buildCommon(item, "COSE_Signature", 3);
        CBORItem signature = common.get(2);
        if (!(signature instanceof CBORByteArray)) {
            throw new COSEException("The third element (signature) of COSE_Signature must be a byte string.");
        }
        try {
            return new COSESignature((COSEProtectedHeader)common.get(0), (COSEUnprotectedHeader)common.get(1), (CBORByteArray)signature);
        }
        catch (Exception cause) {
            throw new COSEException(cause.getMessage(), cause);
        }
    }

    public static COSESignature build(List<Object> list) throws COSEException {
        return COSESignature.build(new CBORizer().cborizeCollection(list));
    }
}

