/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cose.COSEException;
import com.authlete.cose.ECDSA;
import com.authlete.cose.EdDSA;
import com.authlete.cose.KeyGetter;
import com.authlete.cose.SigStructure;
import java.security.Key;

public class COSESigner {
    private final Key key;
    private final KeyGetter keyGetter;

    public COSESigner(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("'key' must not be null.");
        }
        this.key = key;
        this.keyGetter = null;
    }

    public COSESigner(KeyGetter keyGetter) {
        if (keyGetter == null) {
            throw new IllegalArgumentException("'keyGetter' must not be null.");
        }
        this.key = null;
        this.keyGetter = keyGetter;
    }

    public byte[] sign(SigStructure structure, int algorithm) throws COSEException {
        return this.sign(structure, algorithm, null);
    }

    public byte[] sign(SigStructure structure, int algorithm, byte[] keyID) throws COSEException {
        Key key = this.getKey(algorithm, keyID);
        return COSESigner.sign(key, algorithm, structure.encode());
    }

    private Key getKey(int algorithm, byte[] keyID) throws COSEException {
        if (this.key != null) {
            return this.key;
        }
        Key obtainedKey = this.keyGetter.get(1, algorithm, keyID);
        if (obtainedKey == null) {
            throw new COSEException(String.format("A key for signing with the algorithm '%d' was not found.", algorithm));
        }
        return obtainedKey;
    }

    public static byte[] sign(Key key, int alg, byte[] data) throws COSEException {
        switch (alg) {
            case -36: 
            case -35: 
            case -7: {
                return ECDSA.sign(key, alg, data);
            }
            case -8: {
                return EdDSA.sign(key, data);
            }
        }
        throw new COSEException(String.format("The algorithm '%d' is not supported.", alg));
    }
}

