/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORPairList;
import com.authlete.cbor.CBORizer;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEHeaderBuilder;
import com.authlete.cose.HeaderValidator;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class COSEUnprotectedHeader
extends CBORPairList {
    private Object alg;
    private Object contentType;
    private byte[] kid;
    private byte[] iv;
    private byte[] partialIv;
    private List<X509Certificate> x5chain;

    public COSEUnprotectedHeader(List<? extends CBORPair> pairs) throws IllegalArgumentException {
        super(pairs);
        this.validateParameters(pairs);
        this.setComment("unprotected");
    }

    private void validateParameters(List<? extends CBORPair> pairs) {
        Map<Object, Object> map = HeaderValidator.validate(pairs, true);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object label = entry.getKey();
            if (!(label instanceof Integer)) continue;
            this.initializeField((Integer)label, entry.getValue());
        }
    }

    private void initializeField(int label, Object value) {
        switch (label) {
            case 1: {
                this.alg = value;
                break;
            }
            case 3: {
                this.contentType = value;
                break;
            }
            case 4: {
                this.kid = (byte[])value;
                break;
            }
            case 5: {
                this.iv = (byte[])value;
                break;
            }
            case 6: {
                this.partialIv = (byte[])value;
                break;
            }
            case 33: {
                this.x5chain = (List)value;
                break;
            }
        }
    }

    public Map<Object, Object> getParameters() {
        return this.parse();
    }

    public Object getAlg() {
        return this.alg;
    }

    public Object getContentType() {
        return this.contentType;
    }

    public byte[] getKid() {
        return this.kid;
    }

    public byte[] getIv() {
        return this.iv;
    }

    public byte[] getPartialIv() {
        return this.partialIv;
    }

    public List<X509Certificate> getX5Chain() {
        return this.x5chain;
    }

    public static COSEUnprotectedHeader build(CBORItem header) throws COSEException {
        if (!(header instanceof CBORPairList)) {
            throw new COSEException("An unprotected header must be a CBOR map.");
        }
        List<? extends CBORPair> pairs = ((CBORPairList)header).getPairs();
        try {
            return new COSEUnprotectedHeader(pairs);
        }
        catch (Exception cause) {
            throw new COSEException(cause.getMessage(), cause);
        }
    }

    public static COSEUnprotectedHeader build(Map<Object, Object> map) {
        if (map == null) {
            map = Collections.emptyMap();
        }
        CBORPairList pairList = (CBORPairList)new CBORizer().cborizeMap(map);
        COSEHeaderBuilder.addHeaderComments(pairList);
        return new COSEUnprotectedHeader(pairList.getPairs());
    }
}

