/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORItem;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEObject;
import com.authlete.cose.COSESign;
import com.authlete.cose.COSESign1;
import com.authlete.cose.COSESignature;
import com.authlete.cose.ECDSA;
import com.authlete.cose.EdDSA;
import com.authlete.cose.KeyGetter;
import com.authlete.cose.SigStructure;
import com.authlete.cose.SigStructureBuilder;
import com.authlete.cose.constants.COSEAlgorithms;
import java.security.Key;

public class COSEVerifier {
    private final Key key;
    private final KeyGetter keyGetter;

    public COSEVerifier(Key key) {
        if (key == null) {
            throw new IllegalArgumentException("'key' must not be null.");
        }
        this.key = key;
        this.keyGetter = null;
    }

    public COSEVerifier(KeyGetter keyGetter) {
        if (keyGetter == null) {
            throw new IllegalArgumentException("'keyGetter' must not be null.");
        }
        this.key = null;
        this.keyGetter = keyGetter;
    }

    public boolean verify(COSESign sign) throws COSEException {
        return this.verify(sign, (byte[])null);
    }

    public boolean verify(COSESign sign, byte[] externalData) throws COSEException {
        for (CBORItem cBORItem : sign.getSignatures().getItems()) {
            if (!this.verify(sign, (COSESignature)cBORItem, externalData)) continue;
            return true;
        }
        return false;
    }

    public boolean verify(COSESign sign, COSESignature signature) throws COSEException {
        return this.verify(sign, signature, null);
    }

    public boolean verify(COSESign sign, COSESignature signature, byte[] externalData) throws COSEException {
        int alg = this.retrieveAlg(signature);
        byte[] kid = this.retrieveKid(signature);
        Key key = this.getKey(alg, kid);
        SigStructure toBeSigned = new SigStructureBuilder().sign(sign).signature(signature).externalData(externalData).build();
        return COSEVerifier.verify(key, alg, toBeSigned.encode(), (byte[])signature.getSignature().getValue());
    }

    public boolean verify(COSESign1 sign1) throws COSEException {
        return this.verify(sign1, (byte[])null);
    }

    public boolean verify(COSESign1 sign1, byte[] externalData) throws COSEException {
        int alg = this.retrieveAlg(sign1);
        byte[] kid = this.retrieveKid(sign1);
        Key key = this.getKey(alg, kid);
        SigStructure toBeSigned = new SigStructureBuilder().sign1(sign1).externalData(externalData).build();
        return COSEVerifier.verify(key, alg, toBeSigned.encode(), (byte[])sign1.getSignature().getValue());
    }

    private int retrieveAlg(COSEObject object) throws COSEException {
        Object alg = object.getProtectedHeader().getAlg();
        if (alg == null) {
            alg = object.getUnprotectedHeader().getAlg();
        }
        if (alg == null) {
            throw new COSEException("Neither the protected header nor the unprotected header contain the 'alg' (1) parameter.");
        }
        if (alg instanceof Number) {
            return ((Number)alg).intValue();
        }
        int identifier = COSEAlgorithms.getValueByName((String)alg);
        if (identifier == 0) {
            throw new COSEException(String.format("The algorithm '%s' is not supported.", (String)alg));
        }
        return identifier;
    }

    private byte[] retrieveKid(COSEObject object) {
        byte[] kid = object.getProtectedHeader().getKid();
        if (kid == null) {
            kid = object.getUnprotectedHeader().getKid();
        }
        return kid;
    }

    private Key getKey(int algorithm, byte[] keyID) throws COSEException {
        if (this.key != null) {
            return this.key;
        }
        Key obtainedKey = this.keyGetter.get(2, algorithm, keyID);
        if (obtainedKey == null) {
            throw new COSEException(String.format("A key for verification with the algorithm '%d' was not found.", algorithm));
        }
        return obtainedKey;
    }

    public static boolean verify(Key key, int alg, byte[] data, byte[] signature) throws COSEException {
        switch (alg) {
            case -36: 
            case -35: 
            case -7: {
                return ECDSA.verify(key, alg, data, signature);
            }
            case -8: {
                return EdDSA.verify(key, data, signature);
            }
        }
        throw new COSEException(String.format("The algorithm '%d' is not supported.", alg));
    }
}

