/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cose.BouncyCastleLoader;
import com.authlete.cose.COSEException;
import com.authlete.cose.ECDSAConstants;
import com.authlete.cose.constants.COSEAlgorithms;
import com.authlete.cose.constants.COSEEllipticCurves;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.InvalidKeySpecException;

class ECDSA {
    private static final BigInteger TWO = new BigInteger("2");
    private static final BigInteger THREE = new BigInteger("3");
    private static final boolean beforeJre9 = System.getProperty("java.version").matches("^1\\.[0-8](\\..*)?$");
    private static Method sSqrtAndRemainder;

    ECDSA() {
    }

    static ECPrivateKey createPrivateKey(Object crv, byte[] d) throws COSEException {
        if (d == null) {
            throw new COSEException("The 'd' parameter is missing.");
        }
        ECPrivateKeySpec keySpec = ECDSA.createPrivateKeySpec(crv, d);
        try {
            return (ECPrivateKey)ECDSA.getKeyFactory().generatePrivate(keySpec);
        }
        catch (InvalidKeySpecException cause) {
            throw new COSEException(String.format("The key spec is invalid: %s", cause.getMessage()), cause);
        }
    }

    private static ECPrivateKeySpec createPrivateKeySpec(Object crv, byte[] d) throws COSEException {
        ECParameterSpec paramSpec = ECDSA.getParameterSpec(crv);
        return new ECPrivateKeySpec(new BigInteger(d), paramSpec);
    }

    static ECPublicKey createPublicKey(Object crv, byte[] x, Object y) throws COSEException {
        if (x == null) {
            throw new COSEException("The 'x' parameter is missing.");
        }
        if (y == null) {
            throw new COSEException("The 'y' parameter is missing.");
        }
        ECPublicKeySpec keySpec = ECDSA.createPublicKeySpec(crv, x, y);
        try {
            return (ECPublicKey)ECDSA.getKeyFactory().generatePublic(keySpec);
        }
        catch (InvalidKeySpecException cause) {
            throw new COSEException(String.format("The key spec is invalid: %s", cause.getMessage()), cause);
        }
    }

    private static ECPublicKeySpec createPublicKeySpec(Object crv, byte[] x, Object y) throws COSEException {
        ECParameterSpec paramSpec = ECDSA.getParameterSpec(crv);
        BigInteger xcoord = new BigInteger(1, x);
        BigInteger ycoord = y instanceof byte[] ? new BigInteger(1, (byte[])y) : ECDSA.uncompressY(paramSpec, xcoord, (Boolean)y);
        return new ECPublicKeySpec(new ECPoint(xcoord, ycoord), paramSpec);
    }

    private static ECParameterSpec getParameterSpec(Object crv) throws COSEException {
        int curve = ECDSA.getCurveIdentifier(crv);
        switch (curve) {
            case 1: {
                return ECDSAConstants.PARAMETER_SPEC_P256;
            }
            case 2: {
                return ECDSAConstants.PARAMETER_SPEC_P384;
            }
            case 3: {
                return ECDSAConstants.PARAMETER_SPEC_P521;
            }
        }
        throw new COSEException(String.format("The curve '%s' is not supported.", crv));
    }

    private static int getCurveIdentifier(Object crv) throws COSEException {
        if (crv == null) {
            throw new COSEException("The 'crv' parameter is missing.");
        }
        if (crv instanceof Integer) {
            return (Integer)crv;
        }
        if (crv instanceof String) {
            return COSEEllipticCurves.getValueByName((String)crv);
        }
        return 0;
    }

    private static BigInteger uncompressY(ECParameterSpec paramSpec, BigInteger x, boolean bit) throws COSEException {
        BigInteger remainder;
        BigInteger y;
        BigInteger p = ((ECFieldFp)paramSpec.getCurve().getField()).getP();
        BigInteger b = paramSpec.getCurve().getB();
        BigInteger x3 = x.pow(3).mod(p);
        BigInteger threeX = THREE.multiply(x).mod(p);
        BigInteger y2 = x3.subtract(threeX).add(b).mod(p);
        try {
            BigInteger[] result = ECDSA.sqrtAndRemainder(y2);
            y = result[0].mod(p);
            remainder = result[1];
        }
        catch (ArithmeticException cause) {
            throw new COSEException("The compressed elliptic curve point is invalid.");
        }
        if (!BigInteger.ZERO.equals(remainder)) {
            throw new COSEException("The compressed elliptic curve point is invalid.");
        }
        if (y.mod(TWO).equals(BigInteger.ONE) != bit) {
            y = p.subtract(y);
        }
        return y;
    }

    private static BigInteger[] sqrtAndRemainder(BigInteger bi) throws COSEException {
        if (sSqrtAndRemainder == null) {
            try {
                sSqrtAndRemainder = BigInteger.class.getMethod("sqrtAndRemainder", new Class[0]);
            }
            catch (Exception cause) {
                throw new COSEException(String.format("Cannot compute the value of the compressed elliptic curve point: %s", cause.getMessage()), cause);
            }
        }
        try {
            return (BigInteger[])sSqrtAndRemainder.invoke((Object)bi, new Object[0]);
        }
        catch (ArithmeticException cause) {
            throw cause;
        }
        catch (Exception cause) {
            throw new COSEException(String.format("Cannot compute the value of the compressed elliptic curve point: %s", cause.getMessage()), cause);
        }
    }

    private static KeyFactory getKeyFactory() throws COSEException {
        try {
            return KeyFactory.getInstance("EC");
        }
        catch (NoSuchAlgorithmException cause) {
            throw new COSEException("The key factory for EC is not available.", cause);
        }
    }

    static byte[] sign(Key key, int algorithm, byte[] data) throws COSEException {
        ECPrivateKey priKey = ECDSA.castByPrivateKey(key, algorithm);
        Signature sig = ECDSA.getSignatureInstance(algorithm);
        ECDSA.initializeForSigning(sig, priKey);
        ECDSA.supplyData(sig, data);
        return ECDSA.generateSignature(sig);
    }

    static boolean verify(Key key, int algorithm, byte[] data, byte[] signature) throws COSEException {
        ECPublicKey pubKey = ECDSA.castByPublicKey(key, algorithm);
        Signature sig = ECDSA.getSignatureInstance(algorithm);
        ECDSA.initializeForVerification(sig, pubKey);
        ECDSA.supplyData(sig, data);
        return ECDSA.verifySignature(sig, signature);
    }

    private static ECPrivateKey castByPrivateKey(Key key, int algorithm) throws COSEException {
        if (!(key instanceof ECPrivateKey)) {
            throw new COSEException(String.format("A key to sign data with the algorithm '%s' must implement the ECPrivateKey interface.", COSEAlgorithms.getNameByValue(algorithm)));
        }
        return (ECPrivateKey)key;
    }

    private static ECPublicKey castByPublicKey(Key key, int algorithm) throws COSEException {
        if (!(key instanceof ECPublicKey)) {
            throw new COSEException(String.format("A key to verify a signature signed with the algorithm '%s' must implement the ECPublicKey interface.", COSEAlgorithms.getNameByValue(algorithm)));
        }
        return (ECPublicKey)key;
    }

    private static Signature getSignatureInstance(int algorithm) throws COSEException {
        String algorithmName = ECDSA.determineAlgorithmName(algorithm);
        ECDSA.ensureProvider();
        try {
            return Signature.getInstance(algorithmName);
        }
        catch (NoSuchAlgorithmException cause) {
            throw new COSEException(String.format("Failed to get a Signature instance for the algorithm '%s'.", algorithmName));
        }
    }

    private static String determineAlgorithmName(int algorithm) throws COSEException {
        switch (algorithm) {
            case -7: {
                return beforeJre9 ? "SHA256withPLAIN-ECDSA" : "SHA256withECDSAinP1363Format";
            }
            case -35: {
                return beforeJre9 ? "SHA384withPLAIN-ECDSA" : "SHA384withECDSAinP1363Format";
            }
            case -36: {
                return beforeJre9 ? "SHA512withPLAIN-ECDSA" : "SHA512withECDSAinP1363Format";
            }
        }
        throw new COSEException(String.format("The ECDSA algorithm '%d' is not supported.", algorithm));
    }

    private static void ensureProvider() {
        if (!beforeJre9) {
            return;
        }
        BouncyCastleLoader.ensureBouncyCastleProviderIsLoaded();
    }

    private static void initializeForSigning(Signature sig, PrivateKey priKey) throws COSEException {
        try {
            sig.initSign(priKey);
        }
        catch (InvalidKeyException cause) {
            throw new COSEException(String.format("Failed to initialize the Signature instance for signing: %s", cause.getMessage()), cause);
        }
    }

    private static void initializeForVerification(Signature sig, PublicKey pubKey) throws COSEException {
        try {
            sig.initVerify(pubKey);
        }
        catch (InvalidKeyException cause) {
            throw new COSEException(String.format("Failed to initialize the Signature instance for verification: %s", cause.getMessage()), cause);
        }
    }

    private static void supplyData(Signature sig, byte[] data) throws COSEException {
        try {
            sig.update(data);
        }
        catch (SignatureException cause) {
            throw new COSEException(String.format("Failed to supply the Signature instance with the data: %s", cause.getMessage()), cause);
        }
    }

    private static byte[] generateSignature(Signature sig) throws COSEException {
        try {
            return sig.sign();
        }
        catch (SignatureException cause) {
            throw new COSEException(String.format("Failed to generate a signature: %s", cause.getMessage()), cause);
        }
    }

    private static boolean verifySignature(Signature sig, byte[] signature) throws COSEException {
        try {
            return sig.verify(signature);
        }
        catch (SignatureException cause) {
            throw new COSEException(String.format("Failed to verify the signature: %s", cause.getMessage()), cause);
        }
    }
}

