/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cose.BouncyCastleLoader;
import com.authlete.cose.COSEException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;

class EdDSA {
    private static final Integer FIFTEEN = 15;
    private static final boolean beforeJre15 = EdDSA.isBeforeJre15();
    private static final String ED_25519 = "Ed25519";

    EdDSA() {
    }

    private static boolean isBeforeJre15() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion.startsWith("1.")) {
            return true;
        }
        int dotIndex = javaVersion.indexOf(46);
        if (dotIndex != -1) {
            return Integer.parseInt(javaVersion.substring(0, dotIndex)) < FIFTEEN;
        }
        return Integer.parseInt(javaVersion) < FIFTEEN;
    }

    static KeyPair generateKeyPair() throws NoSuchAlgorithmException {
        EdDSA.ensureProvider();
        KeyPairGenerator kpg = KeyPairGenerator.getInstance(ED_25519);
        return kpg.generateKeyPair();
    }

    static byte[] sign(Key key, byte[] data) throws COSEException {
        if (!(key instanceof PrivateKey)) {
            throw new COSEException("Key is not a private key");
        }
        PrivateKey privateKey = (PrivateKey)key;
        EdDSA.ensureProvider();
        Signature signature = EdDSA.getSignatureInstance();
        EdDSA.initializeSignatureForSigning(signature, privateKey);
        EdDSA.offerDataToSignature(signature, data);
        return EdDSA.sign(signature);
    }

    static boolean verify(Key key, byte[] data, byte[] signature) throws COSEException {
        if (!(key instanceof PublicKey)) {
            throw new COSEException("Key is not a public key");
        }
        PublicKey publicKey = (PublicKey)key;
        EdDSA.ensureProvider();
        Signature sig = EdDSA.getSignatureInstance();
        EdDSA.initializeSignatureForVerification(sig, publicKey);
        EdDSA.offerDataToSignature(sig, data);
        return EdDSA.verify(sig, signature);
    }

    private static Signature getSignatureInstance() throws COSEException {
        try {
            return Signature.getInstance(ED_25519);
        }
        catch (NoSuchAlgorithmException e) {
            throw new COSEException("Failed to get a Signature instance for the algorithm 'Ed25519'");
        }
    }

    private static void initializeSignatureForSigning(Signature signature, PrivateKey privateKey) throws COSEException {
        try {
            signature.initSign(privateKey);
        }
        catch (InvalidKeyException e) {
            throw new COSEException(String.format("Failed to initialize the Signature instance for signing: %s", e.getMessage()), e);
        }
    }

    private static void offerDataToSignature(Signature signature, byte[] data) throws COSEException {
        try {
            signature.update(data);
        }
        catch (SignatureException e) {
            throw new COSEException(String.format("Failed to offer data to the Signature instance: %s", e.getMessage()), e);
        }
    }

    private static byte[] sign(Signature signature) throws COSEException {
        try {
            return signature.sign();
        }
        catch (SignatureException e) {
            throw new COSEException(String.format("Failed to generate a signature: %s", e.getMessage()), e);
        }
    }

    private static boolean verify(Signature sig, byte[] signature) throws COSEException {
        try {
            return sig.verify(signature);
        }
        catch (SignatureException e) {
            throw new COSEException(String.format("Failed to verify the signature: %s", e.getMessage()), e);
        }
    }

    private static void initializeSignatureForVerification(Signature sig, PublicKey publicKey) throws COSEException {
        try {
            sig.initVerify(publicKey);
        }
        catch (InvalidKeyException e) {
            throw new COSEException(String.format("Failed to initialize the Signature instance for verification: %s", e.getMessage()), e);
        }
    }

    private static void ensureProvider() {
        if (!beforeJre15) {
            return;
        }
        BouncyCastleLoader.ensureBouncyCastleProviderIsLoaded();
    }
}

