/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORBigInteger;
import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORInteger;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORItemList;
import com.authlete.cbor.CBORLong;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORString;
import com.authlete.cbor.CBORValue;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class HeaderValidator {
    private static final String X509 = "X.509";

    HeaderValidator() {
    }

    static Map<Object, Object> validate(List<? extends CBORPair> pairs, boolean unprotected) {
        LinkedHashMap<Object, Object> parameters = new LinkedHashMap<Object, Object>();
        if (pairs == null) {
            return parameters;
        }
        for (CBORPair cBORPair : pairs) {
            HeaderValidator.validateParameter(parameters, cBORPair, unprotected);
        }
        return parameters;
    }

    private static void validateParameter(Map<Object, Object> parameters, CBORPair pair, boolean unprotected) {
        Object label;
        CBORItem key = pair.getKey();
        Object object = label = key instanceof CBORString || HeaderValidator.isInteger(key) ? ((CBORValue)key).getValue() : null;
        if (label == null) {
            throw new IllegalArgumentException("A COSE header label must be an integer or a text string.");
        }
        if (parameters.containsKey(label)) {
            throw new IllegalArgumentException(String.format("The label '%s' is contained in the COSE header more than once.", label.toString()));
        }
        Object value = label instanceof Integer ? HeaderValidator.validateKnownParameter((Integer)label, pair.getValue(), unprotected) : HeaderValidator.parseValue(pair.getValue());
        parameters.put(label, value);
    }

    private static Object validateKnownParameter(int label, CBORItem value, boolean unprotected) {
        switch (label) {
            case 1: {
                HeaderValidator.validateAlg(value);
                break;
            }
            case 2: {
                HeaderValidator.validateCrit(value, unprotected);
                break;
            }
            case 3: {
                HeaderValidator.validateContentType(value);
                break;
            }
            case 4: {
                HeaderValidator.validateKid(value);
                break;
            }
            case 5: {
                HeaderValidator.validateIv(value);
                break;
            }
            case 6: {
                HeaderValidator.validatePartialIv(value);
                break;
            }
            case 33: {
                return HeaderValidator.validateX5Chain(value);
            }
        }
        return HeaderValidator.parseValue(value);
    }

    private static Object parseValue(CBORItem value) {
        return value != null ? value.parse() : null;
    }

    private static void validateAlg(CBORItem value) {
        if (HeaderValidator.isInteger(value) || value instanceof CBORString) {
            return;
        }
        throw new IllegalArgumentException("alg (1) must be an integer or a text string.");
    }

    private static void validateCrit(CBORItem value, boolean unprotected) {
        if (unprotected) {
            throw new IllegalArgumentException("crit (2) must not be present in an unprotected header.");
        }
        if (!(value instanceof CBORItemList)) {
            throw new IllegalArgumentException("crit (2) must be a CBOR array.");
        }
        List<? extends CBORItem> items = ((CBORItemList)value).getItems();
        if (items == null || items.size() == 0) {
            throw new IllegalArgumentException("crit (2) must have at least one element.");
        }
        for (CBORItem cBORItem : items) {
            if (HeaderValidator.isInteger(cBORItem) || cBORItem instanceof CBORString) continue;
            throw new IllegalArgumentException("Elements of crit (2) must be an integer or a text string.");
        }
    }

    private static void validateContentType(CBORItem value) {
        if (value instanceof CBORString) {
            return;
        }
        if (!HeaderValidator.isInteger(value)) {
            throw new IllegalArgumentException("content type (3) must be an integer or a text string.");
        }
        if (HeaderValidator.isNegativeInteger(value)) {
            throw new IllegalArgumentException("content type (3) must not be a negative integer.");
        }
    }

    private static void validateKid(CBORItem value) {
        if (value instanceof CBORByteArray) {
            return;
        }
        throw new IllegalArgumentException("kid (4) must be a byte string.");
    }

    private static void validateIv(CBORItem value) {
        if (value instanceof CBORByteArray) {
            return;
        }
        throw new IllegalArgumentException("IV (5) must be a byte string.");
    }

    private static void validatePartialIv(CBORItem value) {
        if (value instanceof CBORByteArray) {
            return;
        }
        throw new IllegalArgumentException("Partial IV (6) must be a byte string.");
    }

    private static boolean isInteger(CBORItem item) {
        return item instanceof CBORInteger || item instanceof CBORLong || item instanceof CBORBigInteger;
    }

    private static boolean isNegativeInteger(CBORItem item) {
        if (item instanceof CBORInteger) {
            return (Integer)((CBORInteger)item).getValue() < 0;
        }
        if (item instanceof CBORLong) {
            return (Long)((CBORLong)item).getValue() < 0L;
        }
        if (item instanceof CBORBigInteger) {
            return ((BigInteger)((CBORBigInteger)item).getValue()).compareTo(BigInteger.ZERO) < 0;
        }
        return false;
    }

    private static List<X509Certificate> validateX5Chain(CBORItem value) {
        if (value instanceof CBORByteArray) {
            return HeaderValidator.validateX5ChainSingle((byte[])((CBORByteArray)value).getValue());
        }
        if (value instanceof CBORItemList) {
            return HeaderValidator.validateX5ChainArray(((CBORItemList)value).getItems());
        }
        throw new IllegalArgumentException("x5chain (33) must be either a byte string or an array of byte strings.");
    }

    private static List<X509Certificate> validateX5ChainSingle(byte[] der) {
        if (der == null) {
            throw new IllegalArgumentException("x5chain (33) must not be a byte string with an empty value.");
        }
        X509Certificate cert = HeaderValidator.buildCertificate(der);
        return Arrays.asList(cert);
    }

    private static List<X509Certificate> validateX5ChainArray(List<? extends CBORItem> items) {
        if (items == null || items.size() == 0) {
            throw new IllegalArgumentException("x5chain (33) must not be empty.");
        }
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (CBORItem cBORItem : items) {
            if (!(cBORItem instanceof CBORByteArray)) {
                throw new IllegalArgumentException("x5chain (33) contains an element that is not a byte string.");
            }
            byte[] der = (byte[])((CBORByteArray)cBORItem).getValue();
            if (der == null) {
                throw new IllegalArgumentException("x5chain (33) contains a byte string with an empty value.");
            }
            certs.add(HeaderValidator.buildCertificate(der));
        }
        return certs;
    }

    private static X509Certificate buildCertificate(byte[] der) {
        try {
            return (X509Certificate)CertificateFactory.getInstance(X509).generateCertificate(new ByteArrayInputStream(der));
        }
        catch (Exception cause) {
            throw new IllegalArgumentException("x5chain (33) contains a malformed certificate.");
        }
    }
}

