/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORItemList;
import com.authlete.cbor.CBORString;
import com.authlete.cbor.CBORValue;
import com.authlete.cose.COSEProtectedHeader;

public class SigStructure
extends CBORItemList {
    private static final CBORString CONTEXT_SIGNATURE = new CBORString("Signature");
    private static final CBORString CONTEXT_SIGNATURE1 = new CBORString("Signature1");

    public SigStructure(COSEProtectedHeader bodyAttributes, COSEProtectedHeader signerAttributes, CBORByteArray externalData, CBORByteArray payload) {
        super((CBORItem[])new CBORValue[]{CONTEXT_SIGNATURE, bodyAttributes, signerAttributes, externalData, payload});
        SigStructure.validateArgument("bodyAttributes", bodyAttributes);
        SigStructure.validateArgument("signerAttributes", signerAttributes);
        SigStructure.validateArgument("externalData", externalData);
        SigStructure.validateArgument("payload", payload);
    }

    public SigStructure(COSEProtectedHeader bodyAttributes, CBORByteArray externalData, CBORByteArray payload) {
        super((CBORItem[])new CBORValue[]{CONTEXT_SIGNATURE1, bodyAttributes, externalData, payload});
        SigStructure.validateArgument("bodyAttributes", bodyAttributes);
        SigStructure.validateArgument("externalData", externalData);
        SigStructure.validateArgument("payload", payload);
    }

    private static void validateArgument(String name, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("'%s' given to SigStructure's constructor must not be null", name));
        }
    }

    public CBORString getContext() {
        return (CBORString)this.getItems().get(0);
    }

    public COSEProtectedHeader getBodyAttributes() {
        return (COSEProtectedHeader)this.getItems().get(1);
    }

    public COSEProtectedHeader getSignerAttributes() {
        if (this.isSignature()) {
            return (COSEProtectedHeader)this.getItems().get(2);
        }
        return null;
    }

    public CBORByteArray getExternalData() {
        if (this.isSignature()) {
            return (CBORByteArray)this.getItems().get(3);
        }
        return (CBORByteArray)this.getItems().get(2);
    }

    public CBORByteArray getPayload() {
        if (this.isSignature()) {
            return (CBORByteArray)this.getItems().get(4);
        }
        return (CBORByteArray)this.getItems().get(3);
    }

    public boolean isSignature() {
        return this.getContext() == CONTEXT_SIGNATURE;
    }

    public boolean isSignature1() {
        return this.getContext() == CONTEXT_SIGNATURE1;
    }
}

