/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose;

import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORNull;
import com.authlete.cose.COSEProtectedHeader;
import com.authlete.cose.COSESign;
import com.authlete.cose.COSESign1;
import com.authlete.cose.COSESignature;
import com.authlete.cose.SigStructure;
import java.nio.charset.StandardCharsets;

public class SigStructureBuilder {
    private boolean signature;
    private boolean signature1;
    private COSEProtectedHeader bodyAttributes;
    private COSEProtectedHeader signerAttributes;
    private CBORByteArray externalData;
    private CBORByteArray payload;

    public SigStructureBuilder signature() {
        this.signature = true;
        this.signature1 = false;
        return this;
    }

    public SigStructureBuilder signature1() {
        this.signature = false;
        this.signature1 = true;
        return this;
    }

    public SigStructureBuilder bodyAttributes(COSEProtectedHeader attributes) {
        this.bodyAttributes = attributes;
        return this;
    }

    public SigStructureBuilder signerAttributes(COSEProtectedHeader attributes) {
        this.signerAttributes = attributes;
        return this;
    }

    public SigStructureBuilder externalData(CBORByteArray data) {
        this.externalData = data;
        return this;
    }

    public SigStructureBuilder externalData(byte[] data) {
        CBORByteArray ba = data != null ? new CBORByteArray(data) : null;
        return this.externalData(ba);
    }

    public SigStructureBuilder payload(CBORByteArray payload) {
        this.payload = payload;
        return this;
    }

    public SigStructureBuilder payload(byte[] payload) {
        CBORByteArray ba = payload != null ? new CBORByteArray(payload) : null;
        return this.payload(ba);
    }

    public SigStructureBuilder payload(String payload) {
        byte[] bytes = payload != null ? payload.getBytes(StandardCharsets.UTF_8) : null;
        return this.payload(bytes);
    }

    public SigStructureBuilder sign(COSESign sign) {
        this.signature();
        this.bodyAttributes(sign.getProtectedHeader());
        CBORItem payload = sign.getPayload();
        if (payload != null && !(payload instanceof CBORNull)) {
            this.payload((CBORByteArray)payload);
        }
        return this;
    }

    public SigStructureBuilder signature(COSESignature signature) {
        this.signerAttributes(signature.getProtectedHeader());
        return this;
    }

    public SigStructureBuilder sign1(COSESign1 sign1) {
        this.signature1();
        this.bodyAttributes(sign1.getProtectedHeader());
        CBORItem payload = sign1.getPayload();
        if (payload != null && !(payload instanceof CBORNull)) {
            this.payload((CBORByteArray)payload);
        }
        return this;
    }

    public SigStructure build() throws IllegalStateException {
        if (!this.signature && !this.signature1) {
            throw new IllegalStateException("Either the signature() method or the signature1() method must be called.");
        }
        if (this.signature1 && this.signerAttributes != null) {
            throw new IllegalStateException("Signer attributes must not be given in the case of Signature1.");
        }
        if (this.payload == null) {
            throw new IllegalStateException("A payload must be given.");
        }
        if (this.bodyAttributes == null) {
            this.bodyAttributes = new COSEProtectedHeader(new byte[0]);
        }
        if (this.signature && this.signerAttributes == null) {
            this.signerAttributes = new COSEProtectedHeader(new byte[0]);
        }
        if (this.externalData == null) {
            this.externalData = new CBORByteArray(new byte[0]);
        }
        if (this.signature) {
            return new SigStructure(this.bodyAttributes, this.signerAttributes, this.externalData, this.payload);
        }
        return new SigStructure(this.bodyAttributes, this.externalData, this.payload);
    }
}

