/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose.constants;

import java.util.LinkedHashMap;
import java.util.Map;

public final class COSEAlgorithms {
    public static final int RS512 = -259;
    public static final int RS384 = -258;
    public static final int RS256 = -257;
    public static final int ES256K = -47;
    public static final int PS512 = -39;
    public static final int PS384 = -38;
    public static final int PS256 = -37;
    public static final int ES512 = -36;
    public static final int ES384 = -35;
    public static final int EdDSA = -8;
    public static final int ES256 = -7;
    private static final int[] values = new int[]{-259, -258, -257, -47, -39, -38, -37, -36, -35, -8, -7};
    private static final String[] names = new String[]{"RS512", "RS384", "RS256", "ES256K", "PS512", "PS384", "PS256", "ES512", "ES384", "EdDSA", "ES256"};
    private static final Map<Integer, String> valueToNameMap = COSEAlgorithms.createValueToNameMap();
    private static final Map<String, Integer> nameToValueMap = COSEAlgorithms.createNameToValueMap();

    private static Map<Integer, String> createValueToNameMap() {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < values.length; ++i) {
            map.put(values[i], names[i]);
        }
        return map;
    }

    private static Map<String, Integer> createNameToValueMap() {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < names.length; ++i) {
            map.put(names[i], values[i]);
        }
        return map;
    }

    public static int getValueByName(String name) {
        if (name == null) {
            return 0;
        }
        return nameToValueMap.getOrDefault(name, 0);
    }

    public static String getNameByValue(int value) {
        return valueToNameMap.getOrDefault(value, null);
    }

    private COSEAlgorithms() {
    }
}

