/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose.constants;

import java.util.LinkedHashMap;
import java.util.Map;

public final class COSEEllipticCurves {
    public static final int P_256 = 1;
    public static final int P_384 = 2;
    public static final int P_521 = 3;
    public static final int X25519 = 4;
    public static final int X448 = 5;
    public static final int Ed25519 = 6;
    public static final int Ed448 = 7;
    public static final int SECP256K1 = 8;
    public static final String P_256_NAME = "P-256";
    public static final String P_384_NAME = "P-384";
    public static final String P_521_NAME = "P-521";
    public static final String X25519_NAME = "X25519";
    public static final String X448_NAME = "X448";
    public static final String Ed25519_NAME = "Ed25519";
    public static final String Ed448_NAME = "Ed448";
    public static final String SECP256K1_NAME = "secp256k1";
    private static final int[] values = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
    private static final String[] names = new String[]{"P-256", "P-384", "P-521", "X25519", "X448", "Ed25519", "Ed448", "secp256k1"};
    private static final Map<Integer, String> valueToNameMap = COSEEllipticCurves.createValueToNameMap();
    private static final Map<String, Integer> nameToValueMap = COSEEllipticCurves.createNameToValueMap();

    private static Map<Integer, String> createValueToNameMap() {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < values.length; ++i) {
            map.put(values[i], names[i]);
        }
        return map;
    }

    private static Map<String, Integer> createNameToValueMap() {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < names.length; ++i) {
            map.put(names[i], values[i]);
        }
        return map;
    }

    public static int getValueByName(String name) {
        if (name == null) {
            return 0;
        }
        return nameToValueMap.getOrDefault(name, 0);
    }

    public static String getNameByValue(int value) {
        return valueToNameMap.getOrDefault(value, null);
    }

    private COSEEllipticCurves() {
    }
}

