/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cose.constants;

import java.util.LinkedHashMap;
import java.util.Map;

public final class COSEHeaderParameters {
    public static final int ALG = 1;
    public static final int CRIT = 2;
    public static final int CONTENT_TYPE = 3;
    public static final int KID = 4;
    public static final int IV = 5;
    public static final int PARTIAL_IV = 6;
    public static final int X5CHAIN = 33;
    private static final int[] values = new int[]{1, 2, 3, 4, 5, 6, 33};
    private static final String[] names = new String[]{"alg", "crit", "content type", "kid", "IV", "Partial IV", "x5chain"};
    private static final Map<Integer, String> valueToNameMap = COSEHeaderParameters.createValueToNameMap();

    private static Map<Integer, String> createValueToNameMap() {
        LinkedHashMap<Integer, String> map = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < values.length; ++i) {
            map.put(values[i], names[i]);
        }
        return map;
    }

    public static String getNameByValue(int value) {
        return valueToNameMap.getOrDefault(value, null);
    }

    private COSEHeaderParameters() {
    }
}

