/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cwt;

import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORDecoder;
import com.authlete.cbor.CBORDecoderException;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORNull;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORPairList;
import com.authlete.cbor.CBORizer;
import com.authlete.cwt.ClaimsValidator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class CWTClaimsSet
extends CBORPairList {
    private String iss;
    private String sub;
    private String aud;
    private Date exp;
    private Date nbf;
    private Date iat;
    private byte[] cti;
    private byte[] nonce;

    public CWTClaimsSet(List<? extends CBORPair> pairs) throws IllegalArgumentException {
        super(pairs);
        this.validateClaims(pairs);
    }

    private void validateClaims(List<? extends CBORPair> pairs) {
        Map<Object, Object> map = ClaimsValidator.validate(pairs);
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            Object label = entry.getKey();
            if (!(label instanceof Integer)) continue;
            this.initializeField((Integer)label, entry.getValue());
        }
    }

    private void initializeField(int label, Object value) {
        switch (label) {
            case 1: {
                this.iss = (String)value;
                break;
            }
            case 2: {
                this.sub = (String)value;
                break;
            }
            case 3: {
                this.aud = (String)value;
                break;
            }
            case 4: {
                this.exp = (Date)value;
                break;
            }
            case 5: {
                this.nbf = (Date)value;
                break;
            }
            case 6: {
                this.iat = (Date)value;
                break;
            }
            case 7: {
                this.cti = (byte[])value;
                break;
            }
            case 10: {
                this.nonce = (byte[])value;
                break;
            }
        }
    }

    public String getIss() {
        return this.iss;
    }

    public String getSub() {
        return this.sub;
    }

    public String getAud() {
        return this.aud;
    }

    public Date getExp() {
        return this.exp;
    }

    public Date getNbf() {
        return this.nbf;
    }

    public Date getIat() {
        return this.iat;
    }

    public byte[] getCti() {
        return this.cti;
    }

    public String getCtiAsString() {
        return CWTClaimsSet.buildString(this.cti);
    }

    public String getCtiAsStringWithException() throws CharacterCodingException {
        return CWTClaimsSet.buildStringWithException(this.cti);
    }

    public byte[] getNonce() {
        return this.nonce;
    }

    public String getNonceAsString() {
        return CWTClaimsSet.buildString(this.nonce);
    }

    public String getNonceAsStringWithException() throws CharacterCodingException {
        return CWTClaimsSet.buildStringWithException(this.nonce);
    }

    private static String buildString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static String buildStringWithException(byte[] bytes) throws CharacterCodingException {
        if (bytes == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
        return decoder.decode(byteBuffer).toString();
    }

    public static CWTClaimsSet build(CBORItem payload) throws CBORDecoderException {
        List<Object> pairs;
        if (payload instanceof CWTClaimsSet) {
            return (CWTClaimsSet)payload;
        }
        if (payload == null || payload instanceof CBORNull) {
            pairs = null;
        } else if (payload instanceof CBORPairList) {
            pairs = ((CBORPairList)payload).getPairs();
        } else if (payload instanceof CBORByteArray) {
            pairs = CWTClaimsSet.extractPairs((CBORByteArray)payload);
        } else {
            throw new CBORDecoderException(String.format("Unexpected type for the CWT payload: %s", payload.getClass().getSimpleName()));
        }
        if (pairs == null) {
            pairs = Collections.emptyList();
        }
        try {
            return new CWTClaimsSet(pairs);
        }
        catch (Exception cause) {
            throw new CBORDecoderException(String.format("The CWT payload is invalid: %s", cause.getMessage()), cause);
        }
    }

    private static List<? extends CBORPair> extractPairs(CBORByteArray payload) throws CBORDecoderException {
        try {
            CBORDecoder decoder = new CBORDecoder((byte[])payload.getValue());
            return ((CBORPairList)decoder.next()).getPairs();
        }
        catch (IOException cause) {
            throw new CBORDecoderException("The CWT payload failed to be parsed as a CBOR map.", cause);
        }
    }

    public static CWTClaimsSet build(Map<Object, Object> map) throws IllegalArgumentException {
        if (map == null) {
            map = Collections.emptyMap();
        }
        CBORPairList pairList = (CBORPairList)new CBORizer().cborizeMap(map);
        return new CWTClaimsSet(pairList.getPairs());
    }
}

