/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cwt;

import com.authlete.cwt.CWTClaimsSet;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class CWTClaimsSetBuilder {
    private final Map<Object, Object> map = new LinkedHashMap<Object, Object>();

    public CWTClaimsSetBuilder put(Object key, Object value) {
        this.map.put(key, value);
        return this;
    }

    private CWTClaimsSetBuilder putDate(Object key, Date date) {
        return this.put(key, date.getTime() / 1000L);
    }

    private CWTClaimsSetBuilder putByteString(Object key, String string) {
        return this.put(key, string.getBytes(StandardCharsets.UTF_8));
    }

    public CWTClaimsSetBuilder iss(String issuer) {
        return this.put(1, issuer);
    }

    public CWTClaimsSetBuilder sub(String subject) {
        return this.put(2, subject);
    }

    public CWTClaimsSetBuilder aud(String audience) {
        return this.put(3, audience);
    }

    public CWTClaimsSetBuilder exp(Date expirationTime) {
        return this.putDate(4, expirationTime);
    }

    public CWTClaimsSetBuilder exp(long expirationTime) {
        return this.put(4, expirationTime);
    }

    public CWTClaimsSetBuilder nbf(Date notBefore) {
        return this.putDate(5, notBefore);
    }

    public CWTClaimsSetBuilder nbf(long notBefore) {
        return this.put(5, notBefore);
    }

    public CWTClaimsSetBuilder iat(Date issuedAt) {
        return this.putDate(6, issuedAt);
    }

    public CWTClaimsSetBuilder iat(long issuedAt) {
        return this.put(6, issuedAt);
    }

    public CWTClaimsSetBuilder cti(String identifier) {
        return this.putByteString(7, identifier);
    }

    public CWTClaimsSetBuilder cti(byte[] identifier) {
        return this.put(7, identifier);
    }

    public CWTClaimsSetBuilder nonce(String nonce) {
        return this.putByteString(10, nonce);
    }

    public CWTClaimsSetBuilder nonce(byte[] nonce) {
        return this.put(10, nonce);
    }

    public CWTClaimsSet build() {
        return CWTClaimsSet.build(this.map);
    }
}

