/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cwt;

import com.authlete.cbor.CBORByteArray;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEKey;
import com.authlete.cose.COSEProtectedHeader;
import com.authlete.cose.COSEProtectedHeaderBuilder;
import com.authlete.cose.COSESign1;
import com.authlete.cose.COSESign1Builder;
import com.authlete.cose.COSESigner;
import com.authlete.cose.SigStructure;
import com.authlete.cose.SigStructureBuilder;
import com.authlete.cwt.CWT;
import com.authlete.cwt.CWTClaimsSet;
import com.authlete.cwt.CWTClaimsSetBuilder;
import com.google.gson.GsonBuilder;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Date;
import java.util.Map;

public class CWTKeyProofBuilder {
    private static final String CONTENT_TYPE = "openid4vci-proof+cwt";
    private static final String LABEL_COSE_KEY = "COSE_Key";
    private String client;
    private String issuer;
    private Date issuedAt;
    private String nonce;
    private COSEKey key;
    private static final String HELP = "USAGE:%n%n  java %s%n    --issuer ISSUER    # specifies the identifier of the credential issuer.%n    --key FILE         # specifies the file containing a private key in the JWK format.%n    [--client CLIENT]  # specifies the identifier of the client application.%n    [--nonce NONCE]    # specifies the 'c_nonce' value issued by the server.%n    [--issued-at TIME] # specifies the issuance time.%n    [--help]           # shows this help text.%n%nNOTE:%n%n  Supported key algorithms are ES256, ES384 and ES512 only.%n%n  The issuance time can be specified by one of the following formats:%n    (a) integer representing seconds since the Unix epoch%n    (b) string representing a datetime in UTC in the ISO 8601 format%n%n";

    public CWTKeyProofBuilder() {
    }

    private CWTKeyProofBuilder(Options options) {
        this.client = options.client;
        this.issuer = options.issuer;
        this.nonce = options.nonce;
        this.key = options.key;
        this.issuedAt = options.issuedAt;
    }

    public String getClient() {
        return this.client;
    }

    public CWTKeyProofBuilder setClient(String client) {
        this.client = client;
        return this;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public CWTKeyProofBuilder setIssuer(String issuer) {
        this.issuer = issuer;
        return this;
    }

    public Date getIssuedAt() {
        return this.issuedAt;
    }

    public CWTKeyProofBuilder setIssuedAt(Date issuedAt) {
        this.issuedAt = issuedAt;
        return this;
    }

    public String getNonce() {
        return this.nonce;
    }

    public CWTKeyProofBuilder setNonce(String nonce) {
        this.nonce = nonce;
        return this;
    }

    public COSEKey getKey() {
        return this.key;
    }

    public CWTKeyProofBuilder setKey(COSEKey key) {
        this.key = key;
        return this;
    }

    public CWT build() throws IllegalStateException, COSEException {
        this.checkState();
        COSEKey key = this.getKey();
        COSEProtectedHeader protectedHeader = CWTKeyProofBuilder.buildProtectedHeader(key);
        CBORByteArray payload = this.buildPayload();
        byte[] signature = CWTKeyProofBuilder.buildSignature(protectedHeader, payload, key);
        COSESign1 sign1 = CWTKeyProofBuilder.buildSign1(protectedHeader, payload, signature);
        return new CWT(sign1);
    }

    private void checkState() {
        this.checkIssuer();
        this.checkKey();
    }

    private void checkIssuer() {
        if (this.getIssuer() != null) {
            return;
        }
        throw new IllegalStateException("'issuer' is not set.");
    }

    private void checkKey() {
        COSEKey key = this.getKey();
        if (key == null) {
            throw new IllegalStateException("'key' is not set.");
        }
        if (!key.isPrivate()) {
            throw new IllegalStateException("The key is not a private key.");
        }
        Object alg = key.getAlg();
        if (!(alg instanceof Number)) {
            throw new IllegalStateException("The representation of the algorithm of the key is not a number.");
        }
    }

    private static COSEProtectedHeader buildProtectedHeader(COSEKey key) throws COSEException {
        COSEKey pubKey = key.toPublic();
        CBORByteArray pubKeyEmbedded = new CBORByteArray(pubKey.encode(), pubKey);
        return (COSEProtectedHeader)((COSEProtectedHeaderBuilder)((COSEProtectedHeaderBuilder)((COSEProtectedHeaderBuilder)new COSEProtectedHeaderBuilder().alg(key.getAlg())).contentType(CONTENT_TYPE)).put(LABEL_COSE_KEY, pubKeyEmbedded)).build();
    }

    private CBORByteArray buildPayload() {
        CWTClaimsSet claims = this.buildClaims();
        byte[] encodedClaims = claims.encode();
        return new CBORByteArray(encodedClaims);
    }

    private CWTClaimsSet buildClaims() {
        CWTClaimsSetBuilder builder = new CWTClaimsSetBuilder();
        if (this.getClient() != null) {
            builder.iss(this.getClient());
        }
        builder.aud(this.getIssuer());
        builder.iat(this.determineIssuedAt());
        if (this.getNonce() != null) {
            builder.nonce(this.getNonce());
        }
        return builder.build();
    }

    private Date determineIssuedAt() {
        Date iat = this.getIssuedAt();
        if (iat == null) {
            iat = new Date();
        }
        return iat;
    }

    private static byte[] buildSignature(COSEProtectedHeader protectedHeader, CBORByteArray payload, COSEKey signingKey) throws COSEException {
        SigStructure structure = CWTKeyProofBuilder.buildSigStructure(protectedHeader, payload);
        COSESigner signer = CWTKeyProofBuilder.createSigner(signingKey);
        int alg = ((Number)signingKey.getAlg()).intValue();
        byte[] kid = signingKey.getKid();
        return signer.sign(structure, alg, kid);
    }

    private static SigStructure buildSigStructure(COSEProtectedHeader protectedHeader, CBORByteArray payload) {
        return new SigStructureBuilder().signature1().bodyAttributes(protectedHeader).payload(payload).build();
    }

    private static COSESigner createSigner(COSEKey signingKey) throws COSEException {
        return new COSESigner(signingKey.createPrivateKey());
    }

    private static COSESign1 buildSign1(COSEProtectedHeader protectedHeader, CBORByteArray payload, byte[] signature) {
        return new COSESign1Builder().protectedHeader(protectedHeader).payload(payload).signature(signature).build();
    }

    public static void main(String[] args) {
        try {
            Options options = new Options().process(args);
            CWT cwt = new CWTKeyProofBuilder(options).build();
            String rep = cwt.encodeToBase64Url();
            System.out.println(rep);
        }
        catch (Exception cause) {
            System.err.format("ERROR: %s%n", cause.getMessage());
            if (!(cause instanceof IllegalArgumentException)) {
                cause.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private static class Options {
        public String client;
        public String issuer;
        public String nonce;
        public COSEKey key;
        public Date issuedAt;

        private Options() {
        }

        public Options process(String[] args) throws IOException, COSEException {
            this.parse(args);
            this.validate();
            return this;
        }

        private void parse(String[] args) throws IOException, COSEException {
            block16: for (int i = 0; i < args.length; ++i) {
                String arg;
                switch (arg = args[i]) {
                    case "--client": {
                        this.client = this.next(arg, args, ++i);
                        continue block16;
                    }
                    case "--issuer": {
                        this.issuer = this.next(arg, args, ++i);
                        continue block16;
                    }
                    case "--nonce": {
                        this.nonce = this.next(arg, args, ++i);
                        continue block16;
                    }
                    case "--key": {
                        String file = this.next(arg, args, ++i);
                        this.key = this.readKey(file);
                        continue block16;
                    }
                    case "--issued-at": {
                        String issuedAtStr = this.next(arg, args, ++i);
                        this.issuedAt = this.readIssuedAt(issuedAtStr);
                        continue block16;
                    }
                    case "--help": {
                        this.help(0);
                        continue block16;
                    }
                    default: {
                        System.err.format("ERROR: Unexpected argument: %s%n%n", arg);
                        this.help(1);
                    }
                }
            }
        }

        private String next(String arg, String[] args, int index) {
            if (args.length <= index) {
                throw new IllegalArgumentException(String.format("The option '%s' requires a following argument.", arg));
            }
            return args[index];
        }

        private COSEKey readKey(String file) throws IOException, COSEException {
            Path path = Paths.get(file, new String[0]);
            byte[] bytes = Files.readAllBytes(path);
            String string = new String(bytes, StandardCharsets.UTF_8);
            Map map = (Map)new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create().fromJson(string, Map.class);
            return COSEKey.fromJwk(map);
        }

        private Date readIssuedAt(String issuedAtStr) {
            try {
                long seconds = Long.parseLong(issuedAtStr);
                return new Date(seconds * 1000L);
            }
            catch (Exception seconds) {
                try {
                    Instant instant = Instant.parse(issuedAtStr);
                    return Date.from(instant);
                }
                catch (Exception cause) {
                    throw new IllegalArgumentException(String.format("The value specified by the '--issued-at' option is malformed: %s", issuedAtStr));
                }
            }
        }

        private void help(int exitStatus) {
            System.out.format(CWTKeyProofBuilder.HELP, CWTKeyProofBuilder.class.getName());
            System.exit(exitStatus);
        }

        private void validate() {
            if (this.issuer == null) {
                throw new IllegalArgumentException("The '--issuer ISSUER' option is mandatory.");
            }
            if (this.key == null) {
                throw new IllegalArgumentException("The '--key FILE' option is mandatory.");
            }
        }
    }
}

