/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.cwt;

import com.authlete.cbor.CBORBigInteger;
import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORConstants;
import com.authlete.cbor.CBORDouble;
import com.authlete.cbor.CBORFloat;
import com.authlete.cbor.CBORInteger;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORLong;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORString;
import com.authlete.cbor.CBORValue;
import java.math.BigInteger;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class ClaimsValidator {
    ClaimsValidator() {
    }

    static Map<Object, Object> validate(List<? extends CBORPair> pairs) {
        LinkedHashMap<Object, Object> claims = new LinkedHashMap<Object, Object>();
        if (pairs == null) {
            return claims;
        }
        for (CBORPair cBORPair : pairs) {
            ClaimsValidator.validateClaim(claims, cBORPair);
        }
        return claims;
    }

    private static void validateClaim(Map<Object, Object> claims, CBORPair pair) {
        Object label;
        CBORItem key = pair.getKey();
        Object object = label = key instanceof CBORString || ClaimsValidator.isInteger(key) ? ((CBORValue)key).getValue() : null;
        if (label == null) {
            throw new IllegalArgumentException("A CWT claim key must be an integer or a text string.");
        }
        if (claims.containsKey(label)) {
            throw new IllegalArgumentException(String.format("The label '%s' is contained in the CWT payload more than once.", label.toString()));
        }
        Object value = label instanceof Integer ? ClaimsValidator.validateKnownClaim((Integer)label, pair.getValue()) : ClaimsValidator.parseValue(pair.getValue());
        claims.put(label, value);
    }

    private static boolean isInteger(CBORItem item) {
        return item instanceof CBORInteger || item instanceof CBORLong || item instanceof CBORBigInteger;
    }

    private static Object parseValue(CBORItem value) {
        return value != null ? value.parse() : null;
    }

    private static Object validateKnownClaim(int label, CBORItem value) {
        switch (label) {
            case 1: {
                return ClaimsValidator.validateTextString(value, "iss");
            }
            case 2: {
                return ClaimsValidator.validateTextString(value, "sub");
            }
            case 3: {
                return ClaimsValidator.validateTextString(value, "aud");
            }
            case 4: {
                return ClaimsValidator.validateDate(value, "exp");
            }
            case 5: {
                return ClaimsValidator.validateDate(value, "nbf");
            }
            case 6: {
                return ClaimsValidator.validateDate(value, "iat");
            }
            case 7: {
                return ClaimsValidator.validateByteString(value, "cti");
            }
            case 10: {
                return ClaimsValidator.validateByteString(value, "nonce");
            }
        }
        return ClaimsValidator.parseValue(value);
    }

    private static String validateTextString(CBORItem value, String claimName) {
        if (value instanceof CBORString) {
            return (String)((CBORString)value).getValue();
        }
        throw new IllegalArgumentException(String.format("The value of the '%s' claim must be a text string.", claimName));
    }

    private static Date validateDate(CBORItem value, String claimName) {
        long seconds;
        if (value instanceof CBORInteger || value instanceof CBORLong) {
            seconds = ((Number)((CBORValue)value).getValue()).longValue();
        } else if (value instanceof CBORBigInteger) {
            BigInteger bi = (BigInteger)((CBORBigInteger)value).getValue();
            if (bi.compareTo(CBORConstants.BIG_INTEGER_LONG_MIN) < 0 || CBORConstants.BIG_INTEGER_LONG_MAX.compareTo(bi) < 0) {
                throw new IllegalArgumentException(String.format("The value of the '%s' claim is out of the valid range.", claimName));
            }
            seconds = bi.longValue();
        } else if (value instanceof CBORFloat || value instanceof CBORDouble) {
            double d = ((Number)((CBORValue)value).getValue()).doubleValue();
            if (d < -9.223372036854776E18 || 9.223372036854776E18 < d) {
                throw new IllegalArgumentException(String.format("The value of the '%s' claim is out of the valid range.", claimName));
            }
            seconds = (long)d;
        } else {
            throw new IllegalArgumentException(String.format("The value of the '%s' claim must be either an integer or a floating-point number.", claimName));
        }
        if (seconds < 0L) {
            throw new IllegalArgumentException(String.format("The value of the '%s' claim must not be negative.", claimName));
        }
        if (9223372036854775L < seconds) {
            throw new IllegalArgumentException(String.format("The value of the '%s' claim is too big.", claimName));
        }
        long milliseconds = seconds * 1000L;
        return new Date(milliseconds);
    }

    private static byte[] validateByteString(CBORItem value, String claimName) {
        if (value instanceof CBORByteArray) {
            return (byte[])((CBORByteArray)value).getValue();
        }
        throw new IllegalArgumentException(String.format("The value of the '%s' claim must be a byte string.", claimName));
    }
}

