/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.mdoc;

import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORPairList;
import com.authlete.cbor.CBORPairsBuilder;
import com.authlete.cbor.CBORString;
import com.authlete.mdoc.DeviceSigned;
import com.authlete.mdoc.Errors;
import com.authlete.mdoc.IssuerSigned;
import java.util.List;

public class Document
extends CBORPairList {
    private static final CBORString LABEL_DOC_TYPE = new CBORString("docType");
    private static final CBORString LABEL_ISSUER_SIGNED = new CBORString("issuerSigned");
    private static final CBORString LABEL_DEVICE_SIGNED = new CBORString("deviceSigned");
    private static final CBORString LABEL_ERRORS = new CBORString("errors");

    public Document(String docType, IssuerSigned issuerSigned) {
        this(docType, issuerSigned, null, null);
    }

    public Document(String docType, IssuerSigned issuerSigned, DeviceSigned deviceSigned, Errors errors) {
        super(Document.createList(docType, issuerSigned, deviceSigned, errors));
    }

    private static List<CBORPair> createList(String docType, IssuerSigned issuerSigned, DeviceSigned deviceSigned, Errors errors) {
        return new CBORPairsBuilder().addUnlessNull((CBORItem)LABEL_DOC_TYPE, (Object)docType).addUnlessNull((CBORItem)LABEL_ISSUER_SIGNED, issuerSigned).addUnlessNull((CBORItem)LABEL_DEVICE_SIGNED, deviceSigned).addUnlessNull((CBORItem)LABEL_ERRORS, errors).build();
    }
}

