/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.mdoc;

import com.authlete.cbor.CBORByteArray;
import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORString;
import com.authlete.cbor.CBORizer;
import com.authlete.cose.COSEEC2Key;
import com.authlete.cose.COSEException;
import com.authlete.cose.COSEKey;
import com.authlete.cose.COSEProtectedHeader;
import com.authlete.cose.COSEProtectedHeaderBuilder;
import com.authlete.cose.COSESign1;
import com.authlete.cose.COSESign1Builder;
import com.authlete.cose.COSESigner;
import com.authlete.cose.COSEUnprotectedHeader;
import com.authlete.cose.COSEUnprotectedHeaderBuilder;
import com.authlete.cose.SigStructure;
import com.authlete.cose.SigStructureBuilder;
import com.authlete.cose.constants.COSEAlgorithms;
import com.authlete.mdoc.AuthorizedNameSpaces;
import com.authlete.mdoc.DeviceKeyInfo;
import com.authlete.mdoc.DigestIDs;
import com.authlete.mdoc.DigestIDsEntry;
import com.authlete.mdoc.IssuerNameSpaces;
import com.authlete.mdoc.IssuerNameSpacesEntry;
import com.authlete.mdoc.IssuerSigned;
import com.authlete.mdoc.IssuerSignedItem;
import com.authlete.mdoc.IssuerSignedItemBytes;
import com.authlete.mdoc.KeyAuthorizations;
import com.authlete.mdoc.MobileSecurityObject;
import com.authlete.mdoc.MobileSecurityObjectBytes;
import com.authlete.mdoc.ValidityInfo;
import com.authlete.mdoc.ValueDigests;
import com.authlete.mdoc.ValueDigestsEntry;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.ECPrivateKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class IssuerSignedBuilder {
    private static final SecureRandom RANDOM = new SecureRandom();
    private String mDocType;
    private Map<String, Object> mClaims;
    private ValidityInfo mValidityInfo;
    private COSEKey mDeviceKey;
    private COSEEC2Key mIssuerKey;
    private List<X509Certificate> mIssuerCertChain;
    private CBORizer mCBORizer;

    public String getDocType() {
        return this.mDocType;
    }

    public IssuerSignedBuilder setDocType(String docType) {
        this.mDocType = docType;
        return this;
    }

    public Map<String, Object> getClaims() {
        return this.mClaims;
    }

    public IssuerSignedBuilder setClaims(Map<String, Object> claims) {
        this.mClaims = claims;
        return this;
    }

    public ValidityInfo getValidityInfo() {
        return this.mValidityInfo;
    }

    public IssuerSignedBuilder setValidityInfo(ValidityInfo info) {
        this.mValidityInfo = info;
        return this;
    }

    public COSEKey getDeviceKey() {
        return this.mDeviceKey;
    }

    public IssuerSignedBuilder setDeviceKey(COSEKey deviceKey) {
        this.mDeviceKey = deviceKey;
        return this;
    }

    public COSEEC2Key getIssuerKey() {
        return this.mIssuerKey;
    }

    public IssuerSignedBuilder setIssuerKey(COSEEC2Key issuerKey) {
        this.mIssuerKey = issuerKey;
        return this;
    }

    public List<X509Certificate> getIssuerCertChain() {
        return this.mIssuerCertChain;
    }

    public IssuerSignedBuilder setIssuerCertChain(List<X509Certificate> chain) {
        this.mIssuerCertChain = chain;
        return this;
    }

    public CBORizer getCBORizer() {
        return this.mCBORizer;
    }

    public IssuerSignedBuilder setCBORizer(CBORizer cborizer) {
        this.mCBORizer = cborizer;
        return this;
    }

    public IssuerSigned build() throws COSEException, CertificateEncodingException {
        this.checkInput();
        IssuerNameSpaces issuerNameSpaces = this.buildIssuerNameSpaces();
        COSESign1 issuerAuth = this.buildIssuerAuth(issuerNameSpaces);
        return new IssuerSigned(issuerNameSpaces, issuerAuth);
    }

    private void checkInput() {
        if (this.getDocType() == null) {
            throw new IllegalStateException("Doc type is not set.");
        }
        if (this.getIssuerKey() == null) {
            throw new IllegalStateException("Issuer key is not set.");
        }
        if (this.getIssuerCertChain() == null) {
            throw new IllegalStateException("Issuer certificate chain is not set.");
        }
        if (this.getIssuerCertChain().size() == 0) {
            throw new IllegalStateException("Issuer certificate chain is empty.");
        }
    }

    private IssuerNameSpaces buildIssuerNameSpaces() {
        Map<String, Object> claims = this.prepareClaims();
        CBORizer cborizer = this.prepareCBORizer();
        SequentialIntegerGenerator digestIdGenerator = new SequentialIntegerGenerator();
        ArrayList<IssuerNameSpacesEntry> issuerNameSpacesEntries = new ArrayList<IssuerNameSpacesEntry>();
        for (Map.Entry<String, Object> entry : claims.entrySet()) {
            String nameSpace = entry.getKey();
            Object subClaims = entry.getValue();
            List<IssuerSignedItemBytes> itemBytesList = this.buildItemBytesList(nameSpace, subClaims, digestIdGenerator, cborizer);
            IssuerNameSpacesEntry issuerNameSpacesEntry = new IssuerNameSpacesEntry(nameSpace, itemBytesList);
            issuerNameSpacesEntries.add(issuerNameSpacesEntry);
        }
        return new IssuerNameSpaces((List<? extends IssuerNameSpacesEntry>)issuerNameSpacesEntries);
    }

    private List<IssuerSignedItemBytes> buildItemBytesList(String nameSpace, Object subClaims, SequentialIntegerGenerator digestIdGenerator, CBORizer cborizer) {
        if (!(subClaims instanceof Map)) {
            throw new IllegalArgumentException(String.format("The value for the name space '%s' is not a JSON object.", nameSpace));
        }
        ArrayList<IssuerSignedItemBytes> itemBytesList = new ArrayList<IssuerSignedItemBytes>();
        for (Map.Entry<String, Object> entry : ((Map)subClaims).entrySet()) {
            IssuerSignedItem item = this.buildIssuerSignedItem(entry, digestIdGenerator, cborizer);
            IssuerSignedItemBytes itemBytes = new IssuerSignedItemBytes(item);
            itemBytesList.add(itemBytes);
        }
        return itemBytesList;
    }

    private IssuerSignedItem buildIssuerSignedItem(Map.Entry<String, Object> subClaim, SequentialIntegerGenerator digestIdGenerator, CBORizer cborizer) {
        int digestID = digestIdGenerator.next();
        byte[] random = IssuerSignedBuilder.generateRandom();
        String elementIdentifier = subClaim.getKey();
        CBORItem elementValue = cborizer.cborize(subClaim.getValue());
        return new IssuerSignedItem(digestID, random, elementIdentifier, elementValue);
    }

    private COSESign1 buildIssuerAuth(IssuerNameSpaces issuerNameSpaces) throws COSEException, CertificateEncodingException {
        int alg = this.determineIssuerAuthSigningAlgorithm();
        COSEProtectedHeader protectedHeader = this.prepareIssuerAuthProtectedHeader(alg);
        COSEUnprotectedHeader unprotectedHeader = this.prepareIssuerAuthUnprotectedHeader();
        CBORByteArray payload = this.prepareIssuerAuthPayload(issuerNameSpaces);
        SigStructure sigStructure = this.prepareSigStructure(protectedHeader, payload);
        byte[] signature = this.sign(sigStructure, alg);
        return new COSESign1Builder().protectedHeader(protectedHeader).unprotectedHeader(unprotectedHeader).payload(payload).signature(signature).build();
    }

    private int determineIssuerAuthSigningAlgorithm() {
        Object alg = this.getIssuerKey().getAlg();
        if (alg != null) {
            return alg instanceof String ? COSEAlgorithms.getValueByName((String)alg) : ((Number)alg).intValue();
        }
        Object crv = this.getIssuerKey().getCrv();
        if (crv == null) {
            throw new IllegalArgumentException("The issuer key does not contain the 'crv' parameter.");
        }
        if (crv.equals(1) || crv.equals("P-256")) {
            return -7;
        }
        if (crv.equals(2) || crv.equals("P-384")) {
            return -35;
        }
        if (crv.equals(3) || crv.equals("P-521")) {
            return -36;
        }
        if (crv.equals(6) || crv.equals("Ed25519")) {
            return -8;
        }
        if (crv.equals(7) || crv.equals("Ed448")) {
            return -8;
        }
        throw new IllegalArgumentException("The curve of the issuer key is not supported.");
    }

    private COSEProtectedHeader prepareIssuerAuthProtectedHeader(int alg) {
        return (COSEProtectedHeader)((COSEProtectedHeaderBuilder)new COSEProtectedHeaderBuilder().alg(alg)).build();
    }

    private COSEUnprotectedHeader prepareIssuerAuthUnprotectedHeader() throws CertificateEncodingException {
        return (COSEUnprotectedHeader)((COSEUnprotectedHeaderBuilder)new COSEUnprotectedHeaderBuilder().x5chain(this.getIssuerCertChain())).build();
    }

    private CBORByteArray prepareIssuerAuthPayload(IssuerNameSpaces issuerNameSpaces) {
        MobileSecurityObjectBytes msoBytes = this.buildMobileSecurityObjectBytes(issuerNameSpaces);
        CBORByteArray payload = new CBORByteArray(msoBytes.encode(), msoBytes);
        payload.setComment("payload");
        return payload;
    }

    private SigStructure prepareSigStructure(COSEProtectedHeader protectedHeader, CBORByteArray payload) {
        return new SigStructureBuilder().signature1().bodyAttributes(protectedHeader).payload(payload).build();
    }

    private byte[] sign(SigStructure sigStructure, int alg) throws COSEException {
        ECPrivateKey privateKey = this.getIssuerKey().toECPrivateKey();
        COSESigner signer = new COSESigner(privateKey);
        return signer.sign(sigStructure, alg);
    }

    private MobileSecurityObjectBytes buildMobileSecurityObjectBytes(IssuerNameSpaces issuerNameSpaces) {
        MobileSecurityObject mso = this.buildMobileSecurityObject(issuerNameSpaces);
        return new MobileSecurityObjectBytes(mso);
    }

    private MobileSecurityObject buildMobileSecurityObject(IssuerNameSpaces issuerNameSpaces) {
        ValueDigests valueDigests = this.buildValueDigests(issuerNameSpaces);
        DeviceKeyInfo deviceKeyInfo = this.buildDeviceKeyInfo(issuerNameSpaces);
        return new MobileSecurityObject(valueDigests, deviceKeyInfo, this.getDocType(), this.getValidityInfo());
    }

    private ValueDigests buildValueDigests(IssuerNameSpaces issuerNameSpaces) {
        List<? extends CBORPair> issuerNameSpacesEntries = issuerNameSpaces.getPairs();
        ArrayList<ValueDigestsEntry> valueDigestsEntries = new ArrayList<ValueDigestsEntry>();
        for (IssuerNameSpacesEntry issuerNameSpacesEntry : issuerNameSpacesEntries) {
            CBORString nameSpace = issuerNameSpacesEntry.getNameSpace();
            List<? extends IssuerSignedItemBytes> issuerSignedItemBytesList = issuerNameSpacesEntry.getIssuerSignedItemBytesList();
            DigestIDs digestIDs = this.buildDigestIDs(issuerSignedItemBytesList);
            ValueDigestsEntry valueDigestsEntry = new ValueDigestsEntry(nameSpace, digestIDs);
            valueDigestsEntries.add(valueDigestsEntry);
        }
        return new ValueDigests((List<? extends ValueDigestsEntry>)valueDigestsEntries);
    }

    private DigestIDs buildDigestIDs(List<? extends IssuerSignedItemBytes> issuerSignedItemBytesList) {
        ArrayList<DigestIDsEntry> digestIDsEntries = new ArrayList<DigestIDsEntry>();
        for (IssuerSignedItemBytes issuerSignedItemBytes : issuerSignedItemBytesList) {
            IssuerSignedItem issuerSignedItem = issuerSignedItemBytes.getIssuerSignedItem();
            int digestID = issuerSignedItem.getDigestID();
            byte[] digest = IssuerSignedBuilder.computeDigest(issuerSignedItemBytes.encode());
            DigestIDsEntry digestIDsEntry = new DigestIDsEntry(digestID, digest);
            digestIDsEntries.add(digestIDsEntry);
        }
        return new DigestIDs((List<? extends DigestIDsEntry>)digestIDsEntries);
    }

    private DeviceKeyInfo buildDeviceKeyInfo(IssuerNameSpaces issuerNameSpaces) {
        COSEKey deviceKey = this.getDeviceKey();
        if (deviceKey == null) {
            return null;
        }
        KeyAuthorizations keyAuthorizations = this.buildKeyAuthorizations(issuerNameSpaces);
        return new DeviceKeyInfo(deviceKey, keyAuthorizations, null);
    }

    private KeyAuthorizations buildKeyAuthorizations(IssuerNameSpaces issuerNameSpaces) {
        AuthorizedNameSpaces authorizedNameSpaces = this.buildAuthorizedNameSpaces(issuerNameSpaces);
        return new KeyAuthorizations(authorizedNameSpaces, null);
    }

    private AuthorizedNameSpaces buildAuthorizedNameSpaces(IssuerNameSpaces issuerNameSpaces) {
        List<? extends CBORPair> issuerNameSpaceEntries = issuerNameSpaces.getPairs();
        List<CBORString> nameSpaces = issuerNameSpaceEntries.stream().map(entry -> entry.getNameSpace()).collect(Collectors.toList());
        return new AuthorizedNameSpaces(nameSpaces);
    }

    private Map<String, Object> prepareClaims() {
        Map<String, Object> claims = this.getClaims();
        if (claims == null) {
            claims = Collections.emptyMap();
        }
        return claims;
    }

    private CBORizer prepareCBORizer() {
        CBORizer cborizer = this.getCBORizer();
        if (cborizer == null) {
            cborizer = new CBORizer();
        }
        return cborizer;
    }

    private static byte[] generateRandom() {
        return IssuerSignedBuilder.generateRandomBytes(16);
    }

    private static byte[] generateRandomBytes(int size) {
        byte[] bytes = new byte[size];
        RANDOM.nextBytes(bytes);
        return bytes;
    }

    private static byte[] computeDigest(byte[] input) {
        return IssuerSignedBuilder.computeDigest(input, "SHA-256");
    }

    private static byte[] computeDigest(byte[] input, String hashAlgorithm) {
        try {
            return MessageDigest.getInstance(hashAlgorithm).digest(input);
        }
        catch (NoSuchAlgorithmException cause) {
            String message = String.format("The hash algorithm '%s' is not supported.", hashAlgorithm);
            throw new RuntimeException(message, cause);
        }
    }

    private static class SequentialIntegerGenerator {
        private int number;

        private SequentialIntegerGenerator() {
        }

        public int next() {
            return ++this.number;
        }
    }
}

