/*
 * Decompiled with CFR 0.152.
 */
package com.authlete.mdoc;

import com.authlete.cbor.CBORItem;
import com.authlete.cbor.CBORPair;
import com.authlete.cbor.CBORPairList;
import com.authlete.cbor.CBORPairsBuilder;
import com.authlete.cbor.CBORString;
import com.authlete.mdoc.DeviceKeyInfo;
import com.authlete.mdoc.ValidityInfo;
import com.authlete.mdoc.ValueDigests;
import java.util.List;

public class MobileSecurityObject
extends CBORPairList {
    private static final String DEFAULT_VERSION = "1.0";
    private static final String DEFAULT_DIGEST_ALGORITHM = "SHA-256";
    private static final CBORString LABEL_VERSION = new CBORString("version");
    private static final CBORString LABEL_DIGEST_ALGORITHM = new CBORString("digestAlgorithm");
    private static final CBORString LABEL_VALUE_DIGESTS = new CBORString("valueDigests");
    private static final CBORString LABEL_DEVICE_KEY_INFO = new CBORString("deviceKeyInfo");
    private static final CBORString LABEL_DOC_TYPE = new CBORString("docType");
    private static final CBORString LABEL_VALIDITY_INFO = new CBORString("validityInfo");

    public MobileSecurityObject(ValueDigests valueDigests, DeviceKeyInfo deviceKeyInfo, String docType, ValidityInfo validityInfo) {
        this(DEFAULT_VERSION, DEFAULT_DIGEST_ALGORITHM, valueDigests, deviceKeyInfo, docType, validityInfo);
    }

    public MobileSecurityObject(String version, String digestAlgorithm, ValueDigests valueDigests, DeviceKeyInfo deviceKeyInfo, String docType, ValidityInfo validityInfo) {
        super(MobileSecurityObject.createList(version, digestAlgorithm, valueDigests, deviceKeyInfo, docType, validityInfo));
    }

    private static List<CBORPair> createList(String version, String digestAlgorithm, ValueDigests valueDigests, DeviceKeyInfo deviceKeyInfo, String docType, ValidityInfo validityInfo) {
        return new CBORPairsBuilder().addUnlessNull((CBORItem)LABEL_VERSION, (Object)version).addUnlessNull((CBORItem)LABEL_DIGEST_ALGORITHM, (Object)digestAlgorithm).addUnlessNull((CBORItem)LABEL_VALUE_DIGESTS, valueDigests).addUnlessNull((CBORItem)LABEL_DEVICE_KEY_INFO, deviceKeyInfo).addUnlessNull((CBORItem)LABEL_DOC_TYPE, (Object)docType).addUnlessNull((CBORItem)LABEL_VALIDITY_INFO, validityInfo).build();
    }
}

